/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.print.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class PrintDataParse {
    private static final List<String> SPECIAL_CHAR = Arrays.asList("z", "Z", "T", "R", "I", "i", "S", "s", "#");
    private String data;
    private List<PrintPart> printParts;

    public PrintDataParse() {
    }

    public PrintDataParse(String data) {
        this.data = data;
        this.printParts = new ArrayList<PrintPart>();
        int count = 0;
        while (StringUtils.isNotBlank((CharSequence)data)) {
            int zindex = data.indexOf("z");
            if (zindex == -1) {
                this.printParts.add(PrintPart.simple(count++, data));
                data = "";
                continue;
            }
            if (zindex == 0) {
                int Zindex = data.indexOf("Z");
                this.printParts.add(PrintPart.cycle(count++, data.substring(2, Zindex)));
                data = data.substring(Zindex + 2);
                continue;
            }
            this.printParts.add(PrintPart.simple(count++, data.substring(0, zindex)));
            data = data.substring(zindex);
        }
        if (!this.printParts.isEmpty()) {
            this.printParts.forEach(part -> part.resolveField());
        }
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public List<PrintPart> getPrintParts() {
        return this.printParts;
    }

    public void setPrintParts(List<PrintPart> printParts) {
        this.printParts = printParts;
    }

    public static class PrintPart
    implements Comparable {
        private Integer order;
        private String part;
        private String filledPart;
        private boolean cycle;
        private List<String> fields;
        private Map<String, String> mappings;

        public PrintPart() {
        }

        public PrintPart(Integer order, String part, boolean cycle) {
            this.order = order;
            this.part = part;
            this.cycle = cycle;
            this.fields = new ArrayList<String>();
        }

        public static PrintPart simple(Integer order, String part) {
            return new PrintPart(order, part, false);
        }

        public static PrintPart cycle(Integer order, String part) {
            return new PrintPart(order, part, true);
        }

        public void resolveField() {
            String[] partArr;
            if (StringUtils.isNotBlank((CharSequence)this.part) && (partArr = this.part.split("\n")) != null && partArr.length > 0) {
                StringBuffer sb = new StringBuffer();
                for (String partStr : partArr) {
                    if (SPECIAL_CHAR.contains(String.valueOf(partStr.charAt(0)))) {
                        this.fields.add(partStr);
                        sb.append("%s");
                        continue;
                    }
                    sb.append(partStr);
                }
                this.filledPart = sb.toString();
            }
        }

        public String mapping(String field) {
            if (StringUtils.isBlank((CharSequence)field)) {
                return "";
            }
            return this.mappings != null ? this.mappings.get(field) : "";
        }

        public PrintPart putMapping(String field, String mapping) {
            this.mappings.put(field, mapping);
            return this;
        }

        public int compareTo(Object o) {
            return this.order.compareTo(((PrintPart)o).getOrder());
        }

        public Integer getOrder() {
            return this.order;
        }

        public void setOrder(Integer order) {
            this.order = order;
        }

        public String getPart() {
            return this.part;
        }

        public void setPart(String part) {
            this.part = part;
        }

        public String getFilledPart() {
            return this.filledPart;
        }

        public void setFilledPart(String filledPart) {
            this.filledPart = filledPart;
        }

        public boolean isCycle() {
            return this.cycle;
        }

        public void setCycle(boolean cycle) {
            this.cycle = cycle;
        }

        public List<String> getFields() {
            return this.fields;
        }

        public void setFields(List<String> fields) {
            this.fields = fields;
        }

        public Map<String, String> getMappings() {
            return this.mappings;
        }

        public void setMappings(Map<String, String> mappings) {
            this.mappings = mappings;
        }
    }
}

