/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.print.dither;

import com.jhscale.meter.protocol.print.dither.DitherEnum;
import com.jhscale.meter.protocol.print.dither.DitherParam;
import com.jhscale.meter.protocol.print.dither.DitherVal;
import com.jhscale.meter.protocol.print.dither.IDithering;
import com.jhscale.meter.protocol.print.dither.ImageBuffer;
import com.jhscale.meter.protocol.print.dither.algorithm.Atkinson;
import com.jhscale.meter.protocol.print.dither.algorithm.Burkes;
import com.jhscale.meter.protocol.print.dither.algorithm.FalseFloydSteinberg;
import com.jhscale.meter.protocol.print.dither.algorithm.FloydSteinberg;
import com.jhscale.meter.protocol.print.dither.algorithm.JarvisJudiceNinke;
import com.jhscale.meter.protocol.print.dither.algorithm.Ordered2By2Bayer;
import com.jhscale.meter.protocol.print.dither.algorithm.Ordered3By3Bayer;
import com.jhscale.meter.protocol.print.dither.algorithm.Ordered4By4Bayer;
import com.jhscale.meter.protocol.print.dither.algorithm.Ordered8By8Bayer;
import com.jhscale.meter.protocol.print.dither.algorithm.RandomDithering;
import com.jhscale.meter.protocol.print.dither.algorithm.Sierra;
import com.jhscale.meter.protocol.print.dither.algorithm.SierraLite;
import com.jhscale.meter.protocol.print.dither.algorithm.SimpleLeftToRightErrorDiffusion;
import com.jhscale.meter.protocol.print.dither.algorithm.SimpleThreshold;
import com.jhscale.meter.protocol.print.dither.algorithm.Stucki;
import com.jhscale.meter.protocol.print.dither.algorithm.TwoRowSierra;
import com.jhscale.meter.protocol.print.image.RGB;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

@Deprecated
public class DitherFactory {
    private DitherFactory() {
    }

    public static BufferedImage rotate(File source, File target, int angel) {
        BufferedImage sourceImage = DitherFactory.read(source);
        System.out.println("Rotate Image...");
        Rectangle rect_des = DitherFactory.CalcRotatedSize(new Rectangle(new Dimension(sourceImage.getWidth(), sourceImage.getHeight())), angel);
        BufferedImage targetImage = new BufferedImage(rect_des.width, rect_des.height, 1);
        Graphics2D g2 = targetImage.createGraphics();
        g2.translate((rect_des.width - sourceImage.getWidth()) / 2, (rect_des.height - sourceImage.getHeight()) / 2);
        g2.rotate(Math.toRadians(angel), sourceImage.getWidth() / 2, sourceImage.getHeight() / 2);
        g2.drawImage(sourceImage, null, null);
        System.out.println("Rotate Image Success.");
        DitherFactory.write(target, targetImage);
        return targetImage;
    }

    public static BufferedImage compress(File source, File target, int width, int height) {
        return DitherFactory.compress(source, target, (Integer)width, (Integer)height, null);
    }

    public static BufferedImage compress(BufferedImage source, File target, int width, int height) {
        return DitherFactory.compress(source, target, (Integer)width, (Integer)height, null);
    }

    public static BufferedImage compress(File source, int width, int height) {
        return DitherFactory.compress(source, null, (Integer)width, (Integer)height, null);
    }

    public static BufferedImage compress(BufferedImage source, int width, int height) {
        return DitherFactory.compress(source, null, (Integer)width, (Integer)height, null);
    }

    public static BufferedImage compress(File source, File target, Double rate) {
        return DitherFactory.compress(source, target, null, null, rate);
    }

    public static BufferedImage compress(BufferedImage source, File target, Double rate) {
        return DitherFactory.compress(source, target, null, null, rate);
    }

    public static BufferedImage compress(File source, Double rate) {
        return DitherFactory.compress(source, null, null, null, rate);
    }

    public static BufferedImage compress(BufferedImage source, Double rate) {
        return DitherFactory.compress(source, null, null, null, rate);
    }

    public static BufferedImage compress(File source, File target, Integer width, Integer height, Double rate) {
        if (source != null && source.exists()) {
            BufferedImage src = DitherFactory.read(source);
            return DitherFactory.compress(src, target, width, height, rate);
        }
        return null;
    }

    public static BufferedImage compress(BufferedImage sourceImage, File target, Integer width, Integer height, Double rate) {
        if (sourceImage != null) {
            System.out.println("Processing compress image...");
            if (rate != null && rate > 0.0) {
                width = (int)((double)sourceImage.getWidth() * rate);
                height = (int)((double)sourceImage.getHeight() * rate);
            }
            BufferedImage tag = new BufferedImage(width, height, 1);
            tag.getGraphics().drawImage(sourceImage.getScaledInstance(width, height, 4), 0, 0, null);
            DitherFactory.write(tag, target);
            return tag;
        }
        return null;
    }

    public static DitherVal dither(File file) {
        return DitherFactory.dither(file, DitherEnum.burkes);
    }

    public static DitherVal dither(BufferedImage sourceImage) {
        BufferedImage targetImage = DitherFactory.dither(sourceImage, null, DitherEnum.burkes, 128);
        return targetImage != null ? new DitherVal(targetImage.getRaster()) : null;
    }

    public static DitherVal dither(BufferedImage sourceImage, DitherParam ditherParam) {
        return new DitherVal(DitherFactory.imageBuffer(sourceImage), ditherParam);
    }

    public static ImageBuffer imageBuffer(BufferedImage sourceImage) {
        ImageBuffer buffer = new ImageBuffer();
        buffer.setMinX(sourceImage.getMinX());
        buffer.setMinY(sourceImage.getMinY());
        buffer.setWidth(sourceImage.getWidth());
        buffer.setHeight(sourceImage.getHeight());
        String[][] RGBHEX = new String[sourceImage.getHeight()][sourceImage.getWidth()];
        for (int j = 0; j < sourceImage.getHeight(); ++j) {
            for (int i = 0; i < sourceImage.getWidth(); ++i) {
                RGBHEX[j][i] = new RGB(sourceImage.getRGB(i, j)).RGB();
            }
        }
        buffer.setRGBHexs(RGBHEX);
        return buffer;
    }

    public static DitherVal dither(File source, File target) {
        return DitherFactory.dither(source, target, DitherEnum.burkes);
    }

    public static DitherVal dither(BufferedImage sourceImage, File target) {
        BufferedImage targetImage = DitherFactory.dither(sourceImage, target, DitherEnum.burkes, 128);
        return targetImage != null ? new DitherVal(targetImage.getRaster()) : null;
    }

    public static DitherVal dither(File file, DitherEnum dither) {
        return DitherFactory.dither(file, null, dither);
    }

    public static DitherVal dither(File source, File target, DitherEnum dither) {
        BufferedImage targetImage = DitherFactory.dither(source, target, dither, 128);
        return targetImage != null ? new DitherVal(targetImage.getRaster()) : null;
    }

    public static BufferedImage dither(File source, File target, DitherEnum dither, int threshold) {
        BufferedImage sourceImage = DitherFactory.read(source);
        return DitherFactory.dither(sourceImage, target, dither, threshold);
    }

    private static void write(File target, BufferedImage image) {
        try {
            if (target != null && image != null) {
                System.out.println("Dither Image Writing...");
                File parentFile = target.getParentFile();
                if (!parentFile.exists()) {
                    parentFile.mkdirs();
                }
                String destinationPath = target.getAbsolutePath();
                String suffix = destinationPath.substring(destinationPath.lastIndexOf(".") + 1, destinationPath.length());
                ImageIO.write((RenderedImage)image, suffix, target);
                System.out.println("Dither Image Write Success.");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write(BufferedImage image, File target) {
        FileOutputStream out = null;
        try {
            if (target != null && image != null) {
                System.out.println("Compress Image Writing...");
                File parentFile = target.getParentFile();
                if (!parentFile.exists()) {
                    parentFile.mkdirs();
                }
                out = new FileOutputStream(target);
                JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
                encoder.encode(image);
                System.out.println("Compress Image Writing...");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static BufferedImage read(File source) {
        BufferedImage sourceImage = null;
        if (source != null && source.exists()) {
            try {
                sourceImage = ImageIO.read(source);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sourceImage;
    }

    private static BufferedImage dither(BufferedImage sourceImage, File target, DitherEnum dither, int threshold) {
        BufferedImage targetImage = DitherFactory.dither(dither, sourceImage, threshold);
        DitherFactory.write(target, targetImage);
        return targetImage;
    }

    public static Rectangle CalcRotatedSize(Rectangle src, int angel) {
        if (angel >= 90) {
            if (angel / 90 % 2 == 1) {
                int temp = src.height;
                src.height = src.width;
                src.width = temp;
            }
            angel %= 90;
        }
        double r = Math.sqrt(src.height * src.height + src.width * src.width) / 2.0;
        double len = 2.0 * Math.sin(Math.toRadians(angel) / 2.0) * r;
        double angel_alpha = (Math.PI - Math.toRadians(angel)) / 2.0;
        double angel_dalta_width = Math.atan((double)src.height / (double)src.width);
        double angel_dalta_height = Math.atan((double)src.width / (double)src.height);
        int len_dalta_width = (int)(len * Math.cos(Math.PI - angel_alpha - angel_dalta_width));
        int len_dalta_height = (int)(len * Math.cos(Math.PI - angel_alpha - angel_dalta_height));
        int des_width = src.width + len_dalta_width * 2;
        int des_height = src.height + len_dalta_height * 2;
        return new Rectangle(new Dimension(des_width, des_height));
    }

    private static BufferedImage dither(DitherEnum dither, BufferedImage source, int threshold) {
        if (source != null) {
            System.out.println("Processing dither image...");
            IDithering dithering = null;
            switch (dither) {
                case ordered2By2Bayer: {
                    dithering = new Ordered2By2Bayer();
                    break;
                }
                case ordered3By3Bayer: {
                    dithering = new Ordered3By3Bayer();
                    break;
                }
                case ordered4By4Bayer: {
                    dithering = new Ordered4By4Bayer();
                    break;
                }
                case ordered8By8Bayer: {
                    dithering = new Ordered8By8Bayer();
                    break;
                }
                case floydSteinberg: {
                    dithering = new FloydSteinberg();
                    break;
                }
                case jarvisJudiceNinke: {
                    dithering = new JarvisJudiceNinke();
                    break;
                }
                case sierra: {
                    dithering = new Sierra();
                    break;
                }
                case twoRowSierra: {
                    dithering = new TwoRowSierra();
                    break;
                }
                case sierraLite: {
                    dithering = new SierraLite();
                    break;
                }
                case atkinson: {
                    dithering = new Atkinson();
                    break;
                }
                case stucki: {
                    dithering = new Stucki();
                    break;
                }
                case burkes: {
                    dithering = new Burkes();
                    break;
                }
                case falseFloydSteinberg: {
                    dithering = new FalseFloydSteinberg();
                    break;
                }
                case simpleLeftToRightErrorDiffusion: {
                    dithering = new SimpleLeftToRightErrorDiffusion();
                    break;
                }
                case randomDithering: {
                    dithering = new RandomDithering();
                    break;
                }
                case simpleThreshold: {
                    dithering = new SimpleThreshold();
                    break;
                }
            }
            if (dithering != null) {
                return dithering.dither(source, threshold);
            }
        }
        return null;
    }
}

