/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.print.dither.algorithm;

import com.jhscale.meter.protocol.print.dither.IDithering;
import com.jhscale.meter.protocol.print.dither.ImageBuffer;
import com.jhscale.meter.protocol.print.image.ImageProcess;
import com.jhscale.meter.protocol.print.image.RGB;
import java.awt.Color;
import java.awt.image.BufferedImage;

public class Burkes
implements IDithering {
    @Override
    public BufferedImage dither(BufferedImage source, int threshold) {
        BufferedImage out = new BufferedImage(source.getWidth(), source.getHeight(), 1);
        int width = source.getWidth();
        int height = source.getHeight();
        int error = 0;
        int[][] errors = new int[width][height];
        for (int y = 0; y < height - 1; ++y) {
            for (int x = 2; x < width - 2; ++x) {
                int pixel = source.getRGB(x, y);
                Color withAlpha = new Color(pixel, true);
                int alpha = withAlpha.getAlpha();
                int red = withAlpha.getRed();
                int gray = red;
                if (gray + errors[x][y] < threshold) {
                    error = gray + errors[x][y];
                    gray = 0;
                } else {
                    error = gray + errors[x][y] - 255;
                    gray = 255;
                }
                int[] nArray = errors[x + 1];
                int n = y;
                nArray[n] = nArray[n] + 8 * error / 32;
                int[] nArray2 = errors[x + 2];
                int n2 = y;
                nArray2[n2] = nArray2[n2] + 4 * error / 32;
                int[] nArray3 = errors[x - 2];
                int n3 = y + 1;
                nArray3[n3] = nArray3[n3] + 2 * error / 32;
                int[] nArray4 = errors[x - 1];
                int n4 = y + 1;
                nArray4[n4] = nArray4[n4] + 4 * error / 32;
                int[] nArray5 = errors[x];
                int n5 = y + 1;
                nArray5[n5] = nArray5[n5] + 8 * error / 32;
                int[] nArray6 = errors[x + 1];
                int n6 = y + 1;
                nArray6[n6] = nArray6[n6] + 4 * error / 32;
                int[] nArray7 = errors[x + 2];
                int n7 = y + 1;
                nArray7[n7] = nArray7[n7] + 2 * error / 32;
                Color outColor = new Color(gray, gray, gray, alpha);
                out.setRGB(x, y, outColor.getRGB());
            }
        }
        return out;
    }

    @Override
    public ImageBuffer dither(ImageBuffer source, ImageProcess imageProcess, int threshold) {
        int[][] errors = new int[source.getWidth()][source.getHeight()];
        RGB[][] targetRGB = new RGB[source.getHeight()][source.getWidth()];
        ImageBuffer target = source.copy();
        target.setRgbs(targetRGB);
        for (int y = 0; y < source.getHeight() - 1; ++y) {
            for (int x = 2; x < source.getWidth() - 2; ++x) {
                int error;
                RGB RGB2 = source.getRgbs()[y][x];
                int gray = RGB2.getRI();
                if (gray + errors[x][y] < threshold) {
                    error = gray + errors[x][y];
                    gray = 0;
                } else {
                    error = gray + errors[x][y] - 255;
                    gray = 255;
                }
                int[] nArray = errors[x + 1];
                int n = y;
                nArray[n] = nArray[n] + 8 * error / 32;
                int[] nArray2 = errors[x + 2];
                int n2 = y;
                nArray2[n2] = nArray2[n2] + 4 * error / 32;
                int[] nArray3 = errors[x - 2];
                int n3 = y + 1;
                nArray3[n3] = nArray3[n3] + 2 * error / 32;
                int[] nArray4 = errors[x - 1];
                int n4 = y + 1;
                nArray4[n4] = nArray4[n4] + 4 * error / 32;
                int[] nArray5 = errors[x];
                int n5 = y + 1;
                nArray5[n5] = nArray5[n5] + 8 * error / 32;
                int[] nArray6 = errors[x + 1];
                int n6 = y + 1;
                nArray6[n6] = nArray6[n6] + 4 * error / 32;
                int[] nArray7 = errors[x + 2];
                int n7 = y + 1;
                nArray7[n7] = nArray7[n7] + 2 * error / 32;
                targetRGB[y][x] = imageProcess.writeRGB(gray, gray, gray, RGB2.getAlpha());
            }
        }
        return target;
    }
}

