/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.print.dither.algorithm;

import com.jhscale.meter.protocol.print.dither.IDithering;
import com.jhscale.meter.protocol.print.dither.ImageBuffer;
import com.jhscale.meter.protocol.print.image.ImageProcess;
import com.jhscale.meter.protocol.print.image.RGB;
import java.awt.Color;
import java.awt.image.BufferedImage;

public class Ordered8By8Bayer
implements IDithering {
    @Override
    public BufferedImage dither(BufferedImage source, int threshold) {
        BufferedImage out = new BufferedImage(source.getWidth(), source.getHeight(), 1);
        int[][] matrix = new int[][]{{1, 49, 13, 61, 4, 52, 16, 64}, {33, 17, 45, 29, 36, 20, 48, 32}, {9, 57, 5, 53, 12, 60, 8, 56}, {41, 25, 37, 21, 44, 28, 40, 24}, {3, 51, 15, 63, 2, 50, 14, 62}, {35, 19, 47, 31, 34, 18, 46, 30}, {11, 59, 7, 55, 10, 58, 6, 54}, {43, 27, 39, 23, 42, 26, 38, 22}};
        int width = source.getWidth();
        int height = source.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int red;
                int pixel = source.getRGB(x, y);
                Color withAlpha = new Color(pixel, true);
                int alpha = withAlpha.getAlpha();
                int gray = red = withAlpha.getRed();
                gray = (gray += gray * matrix[x % 8][y % 8] / 65) < threshold ? 0 : 255;
                Color outColor = new Color(gray, gray, gray, alpha);
                out.setRGB(x, y, outColor.getRGB());
            }
        }
        return out;
    }

    @Override
    public ImageBuffer dither(ImageBuffer source, ImageProcess imageProcess, int threshold) {
        int[][] matrix = new int[][]{{1, 49, 13, 61, 4, 52, 16, 64}, {33, 17, 45, 29, 36, 20, 48, 32}, {9, 57, 5, 53, 12, 60, 8, 56}, {41, 25, 37, 21, 44, 28, 40, 24}, {3, 51, 15, 63, 2, 50, 14, 62}, {35, 19, 47, 31, 34, 18, 46, 30}, {11, 59, 7, 55, 10, 58, 6, 54}, {43, 27, 39, 23, 42, 26, 38, 22}};
        RGB[][] targetRGB = new RGB[source.getHeight()][source.getWidth()];
        ImageBuffer target = source.copy();
        target.setRgbs(targetRGB);
        for (int y = 0; y < source.getHeight(); ++y) {
            for (int x = 0; x < source.getWidth(); ++x) {
                RGB RGB2 = source.getRgbs()[y][x];
                int gray = RGB2.getRI();
                gray = (gray += gray * matrix[x % 8][y % 8] / 65) < threshold ? 0 : 255;
                targetRGB[y][x] = imageProcess.writeRGB(gray, gray, gray, RGB2.getAlpha());
            }
        }
        return target;
    }
}

