/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.print.dither.algorithm;

import com.jhscale.meter.protocol.print.dither.IDithering;
import com.jhscale.meter.protocol.print.dither.ImageBuffer;
import com.jhscale.meter.protocol.print.image.ImageProcess;
import com.jhscale.meter.protocol.print.image.RGB;
import java.awt.Color;
import java.awt.image.BufferedImage;

public class SimpleLeftToRightErrorDiffusion
implements IDithering {
    @Override
    public BufferedImage dither(BufferedImage source, int threshold) {
        BufferedImage out = new BufferedImage(source.getWidth(), source.getHeight(), 1);
        int width = source.getWidth();
        int height = source.getHeight();
        for (int y = 0; y < height; ++y) {
            int error = 0;
            for (int x = 0; x < width; ++x) {
                int delta;
                int pixel = source.getRGB(x, y);
                Color withAlpha = new Color(pixel, true);
                int alpha = withAlpha.getAlpha();
                int red = withAlpha.getRed();
                int gray = red;
                if (gray + error < threshold) {
                    delta = gray;
                    gray = 0;
                } else {
                    delta = gray - 255;
                    gray = 255;
                }
                if (Math.abs(delta) < 10) {
                    delta = 0;
                }
                error += delta;
                Color outColor = new Color(gray, gray, gray, alpha);
                out.setRGB(x, y, outColor.getRGB());
            }
        }
        return out;
    }

    @Override
    public ImageBuffer dither(ImageBuffer source, ImageProcess imageProcess, int threshold) {
        RGB[][] targetRGB = new RGB[source.getHeight()][source.getWidth()];
        ImageBuffer target = source.copy();
        target.setRgbs(targetRGB);
        for (int y = 0; y < source.getHeight(); ++y) {
            int error = 0;
            for (int x = 0; x < source.getWidth(); ++x) {
                int delta;
                RGB RGB2 = source.getRgbs()[y][x];
                int gray = RGB2.getRI();
                if (gray + error < threshold) {
                    delta = gray;
                    gray = 0;
                } else {
                    delta = gray - 255;
                    gray = 255;
                }
                if (Math.abs(delta) < 10) {
                    delta = 0;
                }
                error += delta;
                targetRGB[y][x] = imageProcess.writeRGB(gray, gray, gray, RGB2.getAlpha());
            }
        }
        return target;
    }
}

