/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.print.em;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public enum Font {
    FONT(0, "00", "16*16"),
    FONT1(1, "01", "24*24"),
    FONT2(2, "02", "32*32"),
    FONT3(3, "03", "32*16"),
    FONT4(4, "04", "48*24"),
    FONT5(5, "05", "64*32"),
    FONT6(6, "06", "48*48"),
    FONT7(7, "07", "64*64"),
    FONT8(8, "08", "96*48"),
    FONT9(9, "09", "96*96");

    private Integer val;
    private String hexVal;
    private String description;

    private Font(Integer val, String hexVal, String description) {
        this.val = val;
        this.hexVal = hexVal;
        this.description = description;
    }

    public Integer getVal() {
        return this.val;
    }

    public String getHexVal() {
        return this.hexVal;
    }

    public String getDescription() {
        return this.description;
    }

    public static Font getFont(Integer val) {
        if (Objects.nonNull(val)) {
            for (Font font : Font.values()) {
                if (!font.getVal().equals(val)) continue;
                return font;
            }
        }
        return null;
    }

    public static Font getFont(String hexVal) {
        if (StringUtils.isNotBlank((CharSequence)hexVal)) {
            for (Font font : Font.values()) {
                if (!font.getHexVal().equals(hexVal)) continue;
                return font;
            }
        }
        return null;
    }
}

