/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.print.entity;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.print.PrintCommunication;
import com.jhscale.meter.protocol.print.entity.PrintMark;
import com.jhscale.meter.protocol.print.entity.PrintResponse;
import com.jhscale.meter.protocol.print.entity._interface.IPrintRequest;
import com.jhscale.meter.protocol.print.link.IPrintBack;
import com.jhscale.meter.utils.PrintUtils;
import org.apache.commons.lang3.StringUtils;

public class PrintRequest<T extends PrintResponse>
implements IPrintRequest {
    private PrintCommunication communication;
    private IPrintBack printBack;
    private String content = "";
    private String subContent = "";
    private boolean first = true;
    private Integer start = 0;
    private Integer end = 0;
    private String crc;
    private boolean sdk = false;
    private boolean all = false;
    private boolean upgrade = false;

    public boolean isStart() {
        return this.start == 0;
    }

    public boolean isEnd() {
        return this.end.equals(this.content.length());
    }

    public String subContent() {
        this.subContent = this.content.substring(this.start, this.end);
        return this.subContent;
    }

    public Integer subContentLength() {
        return this.subContent.length();
    }

    public String subContentHexLength() {
        String hexLength = Integer.toHexString(this.subContentLength() / 2);
        return hexLength.length() % 2 != 0 ? "0" + hexLength : hexLength;
    }

    public PrintRequest setSubContentLength(Integer bufferLength) {
        this.start = this.end;
        this.end = this.end + bufferLength;
        if (this.end > this.content.length()) {
            this.end = this.content.length();
        }
        PrintUtils.debug(this.communication.param(), String.format("bufferLength\uff1a[%s]\uff0c start\uff1a[%s]\uff0cend\uff1a[%s]", bufferLength, this.start, this.end));
        return this;
    }

    public boolean sendEnd() {
        return this.end.equals(this.content.length());
    }

    public boolean hasCrc() {
        return StringUtils.isNotBlank((CharSequence)this.crc);
    }

    public String cmd() throws MeterException {
        PrintMark mark = new PrintMark(false, this.hasCrc(), this.isStart(), this.isEnd(), this.printType());
        String content = this.subContent();
        PrintUtils.debug(this.communication.param(), String.format("Content: [ %s ]\uff0cSubContent: [ %s ]", this.getContent(), content));
        String contentHexLength = this.subContentHexLength();
        return new StringBuffer("02").append(mark.buildMark()).append(contentHexLength).append(content).toString();
    }

    public IPrintBack getPrintBack() {
        return this.printBack;
    }

    public void setPrintBack(IPrintBack printBack) {
        this.printBack = printBack;
    }

    public PrintCommunication getCommunication() {
        return this.communication;
    }

    public void setCommunication(PrintCommunication communication) {
        this.communication = communication;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getSubContent() {
        return this.subContent;
    }

    public void setSubContent(String subContent) {
        this.subContent = subContent;
    }

    public boolean isFirst() {
        return this.first;
    }

    public void setFirst(boolean first) {
        this.first = first;
    }

    public Integer getStart() {
        return this.start;
    }

    public void setStart(Integer start) {
        this.start = start;
    }

    public Integer getEnd() {
        return this.end;
    }

    public void setEnd(Integer end) {
        this.end = end;
    }

    public String getCrc() {
        return this.crc;
    }

    public void setCrc(String crc) {
        this.crc = crc;
    }

    public boolean isSdk() {
        return this.sdk;
    }

    public void setSdk(boolean sdk) {
        this.sdk = sdk;
    }

    public boolean isAll() {
        return this.all;
    }

    public void setAll(boolean all) {
        this.all = all;
    }

    public boolean isUpgrade() {
        return this.upgrade;
    }

    public void setUpgrade(boolean upgrade) {
        this.upgrade = upgrade;
    }
}

