/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.print.entity;

import com.jhscale.common.utils.SystemtUtils;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterPrintThermalException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.exp.MeterWarningException;
import com.jhscale.meter.protocol.print.PrintFactory;
import com.jhscale.meter.protocol.print.entity.PrintMark;
import com.jhscale.meter.protocol.print.entity.PrintRequest;
import com.jhscale.meter.protocol.print.entity.ScheduleState;
import com.jhscale.meter.protocol.print.entity._interface.IPrintResponse;
import com.jhscale.meter.protocol.print.produce.entity.PrintBackResponse;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.PrintUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class PrintResponse<T extends PrintBackResponse, U extends PrintRequest>
implements IPrintResponse<T, U> {
    private Integer serial;
    private PrintMark mark;
    private int contentLength;
    private String content;
    private String subContent;
    private String crc;
    private String state;
    private Integer bufferLength;
    private Integer receiveLength;
    private String cache = "";

    public Integer getSerial() {
        return this.serial;
    }

    public void setSerial(Integer serial) {
        this.serial = serial;
    }

    public PrintMark getMark() {
        return this.mark;
    }

    public void setMark(PrintMark mark) {
        this.mark = mark;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getCrc() {
        return this.crc;
    }

    public void setCrc(String crc) {
        this.crc = crc;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Integer getBufferLength() {
        return this.bufferLength;
    }

    public Integer bufferLength() {
        return this.bufferLength / 2;
    }

    public void setBufferLength(Integer bufferLength) {
        this.bufferLength = bufferLength;
    }

    public Integer getReceiveLength() {
        return this.receiveLength;
    }

    public void setReceiveLength(Integer receiveLength) {
        this.receiveLength = receiveLength;
    }

    public String toString() {
        return "PrintResponse{serial=" + this.serial + '\'' + ", mark=" + this.mark.toString() + ", contentLength=" + this.contentLength + ", content='" + this.content + '\'' + ", subContent='" + this.subContent + '\'' + ", crc='" + this.crc + '\'' + ", state='" + this.state + '\'' + ", bufferLength=" + this.bufferLength + ", receiveLength=" + this.receiveLength + ", cache='" + this.cache + '\'' + '}';
    }

    @Override
    public void callBack(String responseStr, U request) {
        try {
            block21: {
                this.serial = ((PrintRequest)request).getCommunication().getSerial();
                this.checkResponse(responseStr);
                responseStr = responseStr.replace(" ", "");
                responseStr = this.parse(responseStr);
                if (StringUtils.isBlank((CharSequence)responseStr)) {
                    return;
                }
                this.parseCheck(request);
                if (StringUtils.isNotBlank((CharSequence)this.content)) {
                    try {
                        this.analysis(request);
                        this.analysisCheck((PrintRequest)request);
                    }
                    catch (MeterPrintThermalException e) {
                        this.bufferLength = 0;
                        SystemtUtils.sleep((int)2);
                        PrintUtils.debug(((PrintRequest)request).getCommunication().param(), e.getMessage());
                        ((PrintRequest)request).getCommunication().sendSuccess();
                        if (!Objects.nonNull(((PrintRequest)request).getPrintBack())) break block21;
                        ((PrintRequest)request).getPrintBack().responseBack(PrintBackResponse.warning(((PrintRequest)request).getCommunication().getSerial(), e.getMeterState().getCode(), e.getMeterState().getMsg()));
                    }
                }
            }
            if (this.bufferLength == 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (Objects.nonNull(((PrintRequest)request).getPrintBack())) {
                try {
                    ((PrintRequest)request).getPrintBack().schedule(new ScheduleState(((PrintRequest)request).getCommunication().getSerial(), ((PrintRequest)request).getEnd(), ((PrintRequest)request).getContent().length()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!((PrintRequest)request).isAll() || ((PrintRequest)request).isEnd()) {
                if (((PrintRequest)request).isFirst() || !((PrintRequest)request).sendEnd()) {
                    ((PrintRequest)request).setFirst(false);
                    ((PrintRequest)request).setSubContentLength(this.getBufferLength());
                    ((PrintRequest)request).getCommunication().sendCmd(((PrintRequest)request).cmd(), (PrintRequest)request);
                } else {
                    ((PrintRequest)request).getCommunication().sendSuccess();
                    if (Objects.nonNull(((PrintRequest)request).getPrintBack())) {
                        if (((PrintRequest)request).isSdk() || ((PrintRequest)request).getCommunication().originalResponse()) {
                            ((PrintRequest)request).getPrintBack().responseBack(this);
                        }
                        T response = this.reflexResponse(request);
                        ((PrintRequest)request).getPrintBack().responseBack((PrintBackResponse)response);
                    }
                }
            }
        }
        catch (MeterWarningException e) {
            PrintUtils.debug(((PrintRequest)request).getCommunication().param(), e.getMessage());
            ((PrintRequest)request).getCommunication().sendSuccess();
            if (Objects.nonNull(((PrintRequest)request).getPrintBack())) {
                ((PrintRequest)request).getPrintBack().responseBack(PrintBackResponse.warning(((PrintRequest)request).getCommunication().getSerial(), e.getMeterState()));
            }
        }
        catch (MeterException e) {
            PrintUtils.debug(((PrintRequest)request).getCommunication().param(), e.getMessage());
            ((PrintRequest)request).getCommunication().sendSuccess();
            if (Objects.nonNull(((PrintRequest)request).getPrintBack())) {
                ((PrintRequest)request).getPrintBack().responseBack(PrintBackResponse.fail(((PrintRequest)request).getCommunication().getSerial(), e.getMeterState().getCode(), e.getMeterState().getMsg()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public T reflexResponse(U request) throws MeterException {
        PrintBackResponse response = null;
        try {
            Type genericSuperclass = this.getClass().getGenericSuperclass();
            Type[] actualTypeArguments = ((ParameterizedType)genericSuperclass).getActualTypeArguments();
            Class clazz = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            response = (PrintBackResponse)clazz.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MeterException(MeterStateEnum.\u54cd\u5e94\u5bf9\u8c61\u53cd\u5c04\u5f02\u5e38);
        }
        if (response == null) {
            throw new MeterException(MeterStateEnum.\u54cd\u5e94\u5bf9\u8c61\u53cd\u5c04\u5f02\u5e38);
        }
        response.setSerial(((PrintRequest)request).getCommunication().getSerial());
        response.setCode("000");
        response.setLinkResult("00".equals(this.state));
        if (response.isLinkResult()) {
            this.responseBody(response, request);
        }
        return (T)response;
    }

    @Override
    public boolean checkResponse(String responseStr) throws MeterException {
        System.out.println("check_response_string --- >:" + responseStr);
        if (StringUtils.isBlank((CharSequence)responseStr)) {
            throw new MeterException(MeterStateEnum.\u54cd\u5e94\u4f53\u4e0d\u5b58\u5728);
        }
        if ((responseStr = responseStr.replace(" ", "")).length() % 2 != 0) {
            throw new MeterException(MeterStateEnum.\u54cd\u5e94\u4f53\u65e0\u6548);
        }
        return true;
    }

    @Override
    public String parse(String responseStr) throws MeterException {
        int index;
        if (!responseStr.startsWith("02")) {
            responseStr = this.cache + responseStr;
        }
        if ((index = ByteUtils.indexOf(responseStr, "02")) == -1) {
            System.err.printf("--- \u65e0\u6548\u6570\u636e\u5305\uff1a%s%n", responseStr);
            this.cache = "";
            return "";
        }
        if (!(responseStr = responseStr.substring(index)).startsWith("02")) {
            System.err.printf("--- \u65e0\u6548\u6570\u636e\u5305\uff1a%s%n", responseStr);
            return "";
        }
        try {
            this.mark = new PrintMark(responseStr.substring(2, 4));
            this.contentLength = Integer.parseInt(responseStr.substring(4, 6), 16) * 2;
            this.crc = responseStr.substring(6 + this.contentLength);
            String content = responseStr.substring(6, 6 + this.contentLength);
            this.state = content.substring(0, 2);
            this.bufferLength = Integer.parseInt(content.substring(2, 4), 16) * 2;
            this.receiveLength = Integer.parseInt(content.substring(4, 6), 16) * 2;
            this.content = content.substring(6);
            this.subContent = content.substring(6);
            this.cache = "";
            return responseStr;
        }
        catch (Exception e) {
            System.err.printf("\u6570\u636e\u5305[%s]\u4e0d\u5b8c\u6574\u7f13\u5b58\u7b49\u5f85\u4e0b\u6b21%n", responseStr);
            this.cache = responseStr;
            return null;
        }
    }

    @Override
    public boolean parseCheck(U request) throws MeterException {
        switch (this.getState()) {
            case "00": {
                break;
            }
            case "01": {
                throw new MeterException(MeterStateEnum.\u8d85\u51fa\u7f13\u51b2\u6781\u9650);
            }
            case "02": {
                throw new MeterException(MeterStateEnum.CRC\u6821\u9a8c\u5931\u8d25);
            }
            case "03": {
                throw new MeterException(MeterStateEnum.\u8d85\u51fa\u7f13\u51b2\u6781\u9650\u540c\u65f6CRC\u6821\u9a8c\u5931\u8d25);
            }
            case "04": {
                throw new MeterException(MeterStateEnum.\u8d77\u59cb\u7ed3\u675f\u6807\u5fd7\u65e0\u6548);
            }
            default: {
                System.err.printf("\u672a\u8bc6\u522b\u7684\u72b6\u6001\u7801:[%s]%n", this.getState());
                throw new MeterException(MeterStateEnum.\u672a\u8bc6\u522b\u7684\u72b6\u6001\u7801);
            }
        }
        return true;
    }

    public String parseBytes(Integer length) {
        String part = this.parseLength(length);
        if (StringUtils.isNotBlank((CharSequence)part)) {
            try {
                return String.valueOf(Integer.parseInt(ByteUtils.convert(part), 16));
            }
            catch (Exception e) {
                return part;
            }
        }
        return "";
    }

    public String parseBytesInt(Integer length) {
        String part = this.parseLength(length);
        if (StringUtils.isNotBlank((CharSequence)part)) {
            BigInteger bigInteger = new BigInteger(ByteUtils.convert(part), 16);
            if (bigInteger.bitLength() > 31) {
                bigInteger = bigInteger.subtract(BigInteger.ONE.shiftLeft(32));
            }
            return bigInteger.toString();
        }
        return "";
    }

    public String toBitval() {
        return ByteUtils.formatMark(this.parseLength(1));
    }

    public String parseLength(Integer length) {
        if (StringUtils.isBlank((CharSequence)this.subContent)) {
            return "";
        }
        String res = this.subContent.substring(0, 2 * length);
        this.subContent = this.subContent.substring(length * 2);
        return res;
    }

    public String parseText() {
        if (StringUtils.isBlank((CharSequence)this.subContent)) {
            return "";
        }
        int index = this.index(this.subContent, "00");
        String res = this.subContent.substring(0, index);
        this.subContent = this.subContent.substring(index + 2);
        return new String(ByteUtils.fromHexString(res), PrintFactory.getInstance().charset());
    }

    public String parseTextWithOutCharset() {
        if (StringUtils.isBlank((CharSequence)this.subContent)) {
            return "";
        }
        int index = this.index(this.subContent, "00");
        String res = this.subContent.substring(0, index);
        this.subContent = this.subContent.substring(index + 2);
        return new String(ByteUtils.fromHexString(res));
    }

    private int index(String content, String str) {
        int length = str.length();
        for (int i = 0; i < content.length() / length; ++i) {
            String substring = content.substring(i * 2, (i + 1) * 2);
            if (!substring.equals(str)) continue;
            return i * 2;
        }
        return -1;
    }
}

