/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.print.entity.bitmap;

import com.jhscale.common.model.inter.JSONModel;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.print.PrintFactory;
import com.jhscale.meter.protocol.print.dither.DitherEnum;
import com.jhscale.meter.protocol.print.dither.DitherVal;
import com.jhscale.meter.protocol.print.dither.ImageBuffer;
import com.jhscale.meter.protocol.print.em.Compress;
import com.jhscale.meter.protocol.print.em.Dir;
import com.jhscale.meter.protocol.print.em.DotImage;
import com.jhscale.meter.protocol.print.image.ColorRatioBuilder;
import com.jhscale.meter.protocol.print.image.CompressBuilder;
import com.jhscale.meter.protocol.print.image.DitherBuilder;
import com.jhscale.meter.protocol.print.image.DotplotBuilder;
import com.jhscale.meter.protocol.print.image.FixedCompressBuilder;
import com.jhscale.meter.protocol.print.image.ImageBuilder;
import com.jhscale.meter.protocol.print.image.NinetyRotateBuilder;
import com.jhscale.meter.protocol.print.image.OnehundredandeightyRatateBuilder;
import com.jhscale.meter.protocol.print.image.ProportionCompressBuilder;
import com.jhscale.meter.protocol.print.image.RotateBuilder;
import com.jhscale.meter.protocol.print.image.TwohundredandseventyRatateBuilder;
import com.jhscale.meter.protocol.print.image.ZeroRotateBuilder;
import com.jhscale.meter.utils.ByteUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Objects;

public abstract class BitMap<T extends BitMap>
implements JSONModel {
    private File source;
    private DitherVal ditherVal;
    private Dir dir = Dir.ZERO;
    private boolean _rotate;
    private File rotate;
    private Compress compre_type;
    private int width;
    private int height;
    private double rate = 1.0;
    private boolean _compress = false;
    private File compress;
    private DotImage dotImage;
    private Double colorRatio;
    private DitherEnum ditherType;
    private Integer ditherThreshold;
    private boolean _dither = false;
    private File dither;
    private int lineLength;

    public abstract T bulid();

    public T addSource(File file) {
        this.source = file;
        return (T)this;
    }

    @Deprecated
    public T addSource(DitherVal ditherVal) {
        this.ditherVal = ditherVal;
        return (T)this;
    }

    @Deprecated
    public T dither(File dither) {
        this.dither = dither;
        this._dither = true;
        return (T)this;
    }

    protected T rotate(Dir dir) {
        this.dir = dir;
        return (T)this;
    }

    protected T rotate(Dir dir, File rotate) {
        this.dir = dir;
        this._rotate = true;
        this.rotate = rotate;
        return (T)this;
    }

    public T compress(double rate, File compress) {
        return this.compress(Compress.Proportion, rate, null, null, true, compress);
    }

    public T compress(double rate) {
        return this.compress(Compress.Proportion, rate, null, null, false, null);
    }

    public T compress(int width, int height, File compress) {
        return this.compress(Compress.Width_Height, null, width, height, true, compress);
    }

    public T compress(int width, int height) {
        return this.compress(Compress.Width_Height, null, width, height, false, null);
    }

    private T compress(Compress compre_type, Double rate, Integer width, Integer height, boolean _compress, File compress) {
        this.compre_type = compre_type;
        if (rate != null) {
            this.rate = rate;
        }
        if (width != null) {
            this.width = width;
        }
        if (height != null) {
            this.height = height;
        }
        this._compress = _compress;
        this.compress = compress;
        return (T)this;
    }

    public T dither(Double colorRatio, File dither) {
        return this.dither(DotImage.Color, colorRatio, null, null, true, dither);
    }

    public T dither(Double colorRatio) {
        return this.dither(DotImage.Color, colorRatio, null, null, false, null);
    }

    public T dither(DitherEnum ditherType, Integer ditherThreshold, File dither) {
        return this.dither(DotImage.Dither, null, ditherType, ditherThreshold, true, dither);
    }

    public T dither(DitherEnum ditherType, Integer ditherThreshold) {
        return this.dither(DotImage.Dither, null, ditherType, ditherThreshold, false, null);
    }

    private T dither(DotImage dotImage, Double colorRatio, DitherEnum ditherType, Integer ditherThreshold, boolean _dither, File dither) {
        this.dotImage = dotImage;
        if (Objects.nonNull(colorRatio)) {
            this.colorRatio = colorRatio;
        }
        if (Objects.nonNull((Object)ditherType)) {
            this.ditherType = ditherType;
        }
        if (Objects.nonNull(ditherThreshold)) {
            this.ditherThreshold = ditherThreshold;
        }
        this._dither = _dither;
        this.dither = dither;
        return (T)this;
    }

    public T preterate() throws MeterException {
        if (this.source != null && this.source.exists()) {
            ImageBuffer src;
            if (this.dir != null && this.dir != Dir.ZERO && this._rotate && this.rotate == null) {
                File rotate = new File(this.source.getParentFile(), "rotate");
                if (!rotate.exists()) {
                    rotate.mkdirs();
                }
                this.rotate = new File(rotate, this.source.getName());
            }
            if (this.compre_type != null && this._compress && this.compress == null) {
                File compress = new File(this.source.getParentFile(), "compress");
                if (!compress.exists()) {
                    compress.mkdirs();
                }
                this.compress = new File(compress, this.source.getName());
            }
            if (this._dither && this.dither == null) {
                File dither = new File(this.source.getParentFile(), "dither");
                if (!dither.exists()) {
                    dither.mkdirs();
                }
                this.dither = new File(dither, this.source.getName());
            }
            if (this.dir != null) {
                RotateBuilder dirImageBuilder = null;
                switch (this.dir) {
                    case ZERO: {
                        dirImageBuilder = new ZeroRotateBuilder();
                        break;
                    }
                    case Ninety: {
                        dirImageBuilder = new NinetyRotateBuilder();
                        break;
                    }
                    case One_Hundred_Eighty: {
                        dirImageBuilder = new OnehundredandeightyRatateBuilder();
                        break;
                    }
                    case TWO_Hundred_Seventy: {
                        dirImageBuilder = new TwohundredandseventyRatateBuilder();
                        break;
                    }
                    default: {
                        dirImageBuilder = new ZeroRotateBuilder();
                    }
                }
                src = ((ImageBuilder)((ImageBuilder)((ImageBuilder)((ImageBuilder)dirImageBuilder.addSource(this.source)).addImageProcess(PrintFactory.getInstance().getImageProcess())).addTarget(this.rotate)).build()).getTargetBuffer();
            } else {
                src = PrintFactory.getInstance().getImageProcess().readImage(this.source);
            }
            if (this.compre_type != null) {
                CompressBuilder compreImageBuilder = null;
                switch (this.compre_type) {
                    case Proportion: {
                        compreImageBuilder = new ProportionCompressBuilder().addRate(this.rate);
                        break;
                    }
                    case Width_Height: {
                        compreImageBuilder = new FixedCompressBuilder().addWithdHeight(this.width, this.height);
                        break;
                    }
                    default: {
                        compreImageBuilder = new ProportionCompressBuilder().addRate(this.rate);
                    }
                }
                src = ((ImageBuilder)((ImageBuilder)((ImageBuilder)((ImageBuilder)compreImageBuilder.addSource(src)).addImageProcess(PrintFactory.getInstance().getImageProcess())).addTarget(this.compress)).build()).getTargetBuffer();
            }
            DotplotBuilder dotplotBuilder = null;
            if (Objects.nonNull((Object)this.dotImage)) {
                switch (this.dotImage) {
                    case Color: {
                        dotplotBuilder = new ColorRatioBuilder().addRatio(this.colorRatio);
                        ((ColorRatioBuilder)((ColorRatioBuilder)((ColorRatioBuilder)((ColorRatioBuilder)new ColorRatioBuilder().addRatio(this.colorRatio).addSource(src)).addImageProcess(PrintFactory.getInstance().getImageProcess())).addTarget(this.dither)).build()).getDitherVal();
                        break;
                    }
                    case Dither: {
                        dotplotBuilder = new DitherBuilder().addDither(this.ditherType).addThreshold(this.ditherThreshold);
                        break;
                    }
                    default: {
                        dotplotBuilder = new DitherBuilder();
                    }
                }
            }
            if (dotplotBuilder == null) {
                dotplotBuilder = new DitherBuilder();
            }
            this.ditherVal = ((DotplotBuilder)((ImageBuilder)((ImageBuilder)((ImageBuilder)dotplotBuilder.addSource(src)).addImageProcess(PrintFactory.getInstance().getImageProcess())).addTarget(this.dither)).build()).getDitherVal();
        }
        return (T)this;
    }

    protected int[] append() {
        int residue = this.ditherVal.getWidth() % 8;
        this.lineLength = residue == 0 ? this.ditherVal.getWidth() / 8 : this.ditherVal.getWidth() / 8 + 1;
        return residue != 0 ? new int[8 - residue] : new int[]{};
    }

    protected StringBuffer copyOfRange(DitherVal ditherVal, int[] append) {
        StringBuffer content = new StringBuffer();
        for (int i = 0; i < ditherVal.getHeight(); ++i) {
            int[] val = ByteUtils.byteMerger(Arrays.copyOfRange(ditherVal.getData(), i * ditherVal.getWidth(), (i + 1) * ditherVal.getWidth()), append);
            for (int j = 0; j < val.length / 8; ++j) {
                int[] ints = Arrays.copyOfRange(val, j * 8, (j + 1) * 8);
                String part = "";
                for (int anInt : ints) {
                    part = part + anInt;
                }
                content.append(ByteUtils.int2Hex(Integer.parseInt(part, 2)));
            }
        }
        return content;
    }

    public File getSource() {
        return this.source;
    }

    public File getCompress() {
        return this.compress;
    }

    public File getDither() {
        return this.dither;
    }

    public DitherVal getDitherVal() {
        return this.ditherVal;
    }

    public int getLineLength() {
        return this.lineLength;
    }
}

