/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.print.entity.bitmap;

import com.jhscale.meter.protocol.print.dither.DitherVal;
import com.jhscale.meter.protocol.print.entity.bitmap.BitMap;
import com.jhscale.meter.utils.ByteUtils;
import java.util.ArrayList;

public class FileBitMap
extends BitMap<FileBitMap> {
    private static final String TOP = "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
    private static final int BITMAP_MAX_SIZE = 4096;
    private Integer number;
    private Integer length;
    private Integer size;
    private String content;

    @Override
    public FileBitMap bulid() {
        DitherVal ditherVal = super.getDitherVal();
        if (ditherVal != null && ditherVal.getData() != null && ditherVal.getData().length > 0) {
            StringBuffer buffer = new StringBuffer().append(ByteUtils.completeBytes(this.number, 4)).append(ByteUtils.completeBytes(ditherVal.getWidth(), 2)).append(ByteUtils.completeBytes(ditherVal.getHeight(), 2)).append(TOP);
            StringBuffer result = buffer.append(this.copyOfRange(ditherVal, this.append()));
            this.length = result.length() / 2;
            this.size = this.length % 4096 == 0 ? this.length / 4096 : this.length / 4096 + 1;
            this.content = result.toString();
        }
        return this;
    }

    public FileBitMap setNumber(int number) {
        this.number = number;
        return this;
    }

    public Integer getNumber() {
        return this.number;
    }

    public Integer getLength() {
        return this.length;
    }

    public Integer getSize() {
        return this.size;
    }

    public Integer nextNumber() {
        return (this.number != null || this.number == 0 ? this.number : 1) + (this.size != null ? this.size : 0);
    }

    public Integer[] numbers() {
        ArrayList<Integer> integers = new ArrayList<Integer>();
        if (this.number != null && this.size != null) {
            for (int i = this.number.intValue(); i < this.nextNumber(); ++i) {
                integers.add(i);
            }
        }
        return integers.toArray(new Integer[integers.size()]);
    }

    public String getContent() {
        return this.content;
    }
}

