/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.print.entity.bitmap;

import com.jhscale.meter.protocol.print.dither.DitherVal;
import com.jhscale.meter.protocol.print.em.Dir;
import com.jhscale.meter.protocol.print.entity.ScheduleState;
import com.jhscale.meter.protocol.print.entity.bitmap.BitMap;
import com.jhscale.meter.protocol.print.entity.data.PrintRealBitmapRequest;
import com.jhscale.meter.protocol.print.entity.para.RealBitmapPara;
import java.io.File;

public class RealBitMap
extends BitMap<RealBitMap> {
    private String content;
    private int length;
    private int nowline = 0;
    private int lastLine = 0;

    @Override
    public RealBitMap rotate(Dir dir) {
        return (RealBitMap)super.rotate(dir);
    }

    @Override
    public RealBitMap rotate(Dir dir, File rotate) {
        return (RealBitMap)super.rotate(dir, rotate);
    }

    @Override
    public RealBitMap bulid() {
        DitherVal ditherVal = super.getDitherVal();
        if (ditherVal != null && ditherVal.getData() != null && ditherVal.getData().length > 0) {
            StringBuffer buffer = this.copyOfRange(ditherVal, this.append());
            this.content = buffer.toString();
            this.length = buffer.length() / 2;
        }
        return this;
    }

    public String getContent() {
        return this.content;
    }

    public int getLength() {
        return this.length;
    }

    public boolean checkLine() {
        return super.getDitherVal().getHeight() == this.nowline;
    }

    public void getSubContent(RealBitmapPara realBitmapPara, int bufferLength) {
        realBitmapPara.setStartX(realBitmapPara.getStart_x()).setStartY(realBitmapPara.getStart_y() + this.lastLine);
        int line = bufferLength / super.getLineLength();
        this.lastLine = this.nowline + line > super.getDitherVal().getHeight() ? super.getDitherVal().getHeight() - this.nowline : line;
        int start = super.getLineLength() * this.nowline * 2;
        this.nowline += this.lastLine;
        int end = super.getLineLength() * this.nowline * 2;
        realBitmapPara.setSizeX(super.getDitherVal().getWidth()).setSizeY(this.lastLine).setData(this.content.substring(start, end));
    }

    public ScheduleState schedule(PrintRealBitmapRequest request) {
        return new ScheduleState(request.getCommunication().getSerial(), this.nowline, super.getDitherVal().getHeight());
    }
}

