/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.print.entity.cmd;

import com.jhscale.meter.protocol.print.PrintGeneralFactory;
import com.jhscale.meter.protocol.print.entity.PrintRequest;
import com.jhscale.meter.protocol.print.entity.cmd.PrintCmdResponse;
import com.jhscale.meter.protocol.print.produce.entity.PrintInfoResponse;

public class Print0000Response
extends PrintCmdResponse<PrintInfoResponse, PrintRequest> {
    private String firmwareVersion;
    private String upgradeVersion;
    private String fontVersion;
    private String printState1;
    private String printState2;

    @Override
    public void analysis(PrintRequest request) {
        super.analysis(request);
        this.firmwareVersion = this.parseBytes(4);
        this.upgradeVersion = this.parseBytes(4);
        this.fontVersion = this.parseBytesInt(4);
        this.printState1 = this.toBitval();
        this.printState2 = this.toBitval();
        PrintGeneralFactory.getInstance().putPrintState(this.getSerial(), this.printState1, this.printState2);
    }

    @Override
    public void responseBody(PrintInfoResponse response, PrintRequest request) {
        try {
            response.setFirmwareVersion(this.firmwareVersion);
            response.setUpgradeVersion(this.ConvertNum2Date(this.upgradeVersion));
            response.setUpgrade(this.upgradeVersion);
            response.setFontVersion(this.fontVersion);
            response.setFont(Integer.parseInt(this.fontVersion));
            response.setState1(this.printState1);
            response.setState2(this.printState2);
            response.setBusy('0' == this.printState1.charAt(1));
            response.setCache('0' == this.printState1.charAt(2));
            response.setPaper('0' == this.printState2.charAt(1));
            response.setThermal('0' == this.printState2.charAt(2));
            response.setPaperSoon('0' == this.printState2.charAt(3));
            response.setPaperErr('0' == this.printState2.charAt(4));
            response.setPaperTake('0' == this.printState2.charAt(5));
            response.setUnclosed('0' == this.printState2.charAt(6));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public void setFirmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    public String getUpgradeVersion() {
        return this.upgradeVersion;
    }

    public void setUpgradeVersion(String upgradeVersion) {
        this.upgradeVersion = upgradeVersion;
    }

    public String getFontVersion() {
        return this.fontVersion;
    }

    public void setFontVersion(String fontVersion) {
        this.fontVersion = fontVersion;
    }

    public String getPrintState1() {
        return this.printState1;
    }

    public void setPrintState1(String printState1) {
        this.printState1 = printState1;
    }

    public String getPrintState2() {
        return this.printState2;
    }

    public void setPrintState2(String printState2) {
        this.printState2 = printState2;
    }

    private String ConvertNum2Date(String number) {
        try {
            int num = Integer.parseInt(number);
            int year = num >> 9 & 0x7F;
            int month = num >> 5 & 0xF;
            int day = num & 0x1F;
            return String.valueOf(year * 10000 + month * 100 + day);
        }
        catch (Exception e) {
            e.printStackTrace();
            return number;
        }
    }
}

