/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.print.entity.cmd;

import com.jhscale.common.model.license.RSAEncryptDecrypt;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.print.PrintFactory;
import com.jhscale.meter.protocol.print.em.CardState;
import com.jhscale.meter.protocol.print.entity.PrintRequest;
import com.jhscale.meter.protocol.print.entity.cmd.PrintCmdResponse;
import com.jhscale.meter.protocol.print.produce.entity.JKPInfoResponse;
import com.jhscale.meter.utils.ByteUtils;

public class Print0400Response
extends PrintCmdResponse<JKPInfoResponse, PrintRequest> {
    private String result;
    private String countUp;
    private String innerId;
    private String outerId;
    private String innerCode;

    @Override
    public void responseBody(JKPInfoResponse response, PrintRequest request) throws MeterException {
        response.setState(this.result);
        response.setCountUp(this.countUp);
        response.setInnerId(this.innerId);
        response.setOuterId(this.outerId);
        if (this.innerId != null) {
            response.setInnerCode(this.innerHex(PrintFactory.getInstance().obtainRSAEncryptDecrypt()));
        }
    }

    @Override
    public void analysis(PrintRequest request) {
        super.analysis(request);
        this.result = this.parseLength(1);
        if (CardState.result(this.result)) {
            this.countUp = this.parseBytes(4);
            this.innerId = this.parseTextWithOutCharset();
            this.outerId = this.parseText();
        }
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getCountUp() {
        return this.countUp;
    }

    public void setCountUp(String countUp) {
        this.countUp = countUp;
    }

    public String getInnerId() {
        return this.innerId;
    }

    public void setInnerId(String innerId) {
        this.innerId = innerId;
    }

    public String getOuterId() {
        return this.outerId;
    }

    public void setOuterId(String outerId) {
        this.outerId = outerId;
    }

    public String innerHex(RSAEncryptDecrypt rsaEncryptDecrypt) {
        if (this.innerId != null && rsaEncryptDecrypt != null) {
            return ByteUtils.toHexString(rsaEncryptDecrypt.decrypt(this.innerId.trim().getBytes()));
        }
        return "";
    }
}

