/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.print.entity.cmd;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.print.PrintFactory;
import com.jhscale.meter.protocol.print.em.PrintType;
import com.jhscale.meter.protocol.print.entity.PrintRequest;
import com.jhscale.meter.protocol.print.entity.cmd.PrintCmdResponse;
import com.jhscale.meter.protocol.print.link.IPrintBack;
import com.jhscale.meter.protocol.print.produce.entity.PrintBackResponse;
import com.jhscale.meter.utils.ByteUtils;

public class PrintCmdRequest<T extends PrintCmdResponse>
extends PrintRequest<T> {
    private String cmd;

    public PrintCmdRequest() {
    }

    public PrintCmdRequest(String cmd) {
        this.cmd = cmd;
    }

    @Override
    public PrintType printType() {
        return PrintType.CMD;
    }

    public String getCmd() {
        return this.cmd;
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    @Override
    public StringBuffer assembler() {
        return super.assembler().append(this.cmd);
    }

    @Override
    public void timeOut() {
        block2: {
            try {
                this.getCommunication().sendCmd(this.printType().init(), this);
            }
            catch (MeterException e) {
                e.printStackTrace();
                IPrintBack printBack = this.getPrintBack();
                if (printBack == null) break block2;
                printBack.responseBack(PrintBackResponse.fail(this.getCommunication().getSerial(), "101", "\u8d85\u65f6\u5f02\u5e38:" + e.getMessage()));
            }
        }
        this.getCommunication().sendSuccess();
    }

    public String assemblerText(String text) {
        String result = ByteUtils.toHexString(text.trim().getBytes(PrintFactory.getInstance().charset())).toUpperCase() + "00";
        return result;
    }

    public String int2Byte(int val) {
        return ByteUtils.int2HexWithPush(val, 4);
    }
}

