/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.print.entity.data;

import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.protocol.model.TradeContent;
import com.jhscale.meter.protocol.print.em.PrintType;
import com.jhscale.meter.protocol.print.entity.PrintRequest;
import com.jhscale.meter.protocol.print.entity.data.PrintDataResponse;
import com.jhscale.meter.protocol.print.entity.para.CuttingPosition;
import com.jhscale.meter.protocol.print.entity.para.Para;
import com.jhscale.meter.protocol.print.entity.para.PrintPara;
import com.jhscale.meter.utils.PrintUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class PrintDataRequest<T extends PrintDataResponse>
extends PrintRequest<PrintDataResponse> {
    private String data = "";
    private List<Para> paras;
    private boolean linePrint = false;
    private int initWidthDot = 384;

    @Override
    public PrintType printType() {
        return PrintType.PRINT_DATA;
    }

    @Override
    public StringBuffer assembler() {
        if (this.linePrint && StringUtils.isNotBlank((CharSequence)this.data)) {
            this.data = this.Input_InitWidth() + this.data + this.Input_End();
        }
        return StringUtils.isNotBlank((CharSequence)this.data) ? super.assembler().append(this.data) : super.assembler().append(PrintUtils.compile(this.paras));
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public List<Para> getParas() {
        return this.paras;
    }

    public void setParas(List<Para> paras) {
        this.paras = paras;
    }

    public PrintDataRequest addPara(Para para) {
        if (this.paras == null) {
            this.paras = new ArrayList<Para>();
        }
        this.paras.add(para);
        return this;
    }

    public PrintDataRequest clear() {
        if (this.paras != null) {
            this.paras.clear();
        }
        return this;
    }

    public PrintDataRequest addPrintPoint() {
        return this.addPara(new PrintPara());
    }

    public PrintDataRequest addPrintCutPoint() {
        return this.addPara(new CuttingPosition());
    }

    public PrintDataRequest addPrintPointAndCutPoint() {
        return this.addPrintPoint().addPrintCutPoint();
    }

    private PrintDataRequest<T> Add_Line_Data(String ... data) {
        if (this.data == null) {
            this.data = "";
        }
        if (data != null) {
            for (String datum : data) {
                this.data = this.data + datum;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.data)) {
            this.linePrint = true;
        }
        return this;
    }

    private String Input_InitWidth() {
        int width = GlobalPara.getInstance().getTMS(27);
        width = width != 0 ? width : 48;
        this.initWidthDot = width * 8;
        return "03" + TradeContent.printCalculate_getX2(GlobalPara.getInstance().getTMS(27));
    }

    private String Input_End() {
        return "07";
    }

    public PrintDataRequest<T> Input_Bitmap(int bitmap) {
        String mapInfo = "0000020000000000" + TradeContent.printCalculate_getX4(this.initWidthDot) + "0001";
        return this.Add_Line_Data("16" + mapInfo + TradeContent.printCalculate_getX4(bitmap) + "04");
    }

    public PrintDataRequest<T> Input_String(String left, String mid, String right, int font, boolean multiLine) {
        String mapInfo;
        String head = multiLine ? "0020" : "0000";
        String end = TradeContent.printCalculate_getX2(font) + "00000000" + TradeContent.printCalculate_getX4(this.initWidthDot) + "0001";
        if (StringUtils.isNotBlank((CharSequence)left)) {
            mapInfo = head + "01" + end;
            this.Add_Line_Data("12" + mapInfo + TradeContent.printCalculate_GetTextHex(left));
        }
        if (StringUtils.isNotBlank((CharSequence)mid)) {
            mapInfo = head + "02" + end;
            this.Add_Line_Data("12" + mapInfo + TradeContent.printCalculate_GetTextHex(mid));
        }
        if (StringUtils.isNotBlank((CharSequence)right)) {
            mapInfo = head + "03" + end;
            this.Add_Line_Data("12" + mapInfo + TradeContent.printCalculate_GetTextHex(right));
        }
        return this.Add_Line_Data("04");
    }

    public PrintDataRequest<T> Input_String(String left, String mid, String right) {
        return this.Input_String(left, mid, right, GlobalPara.getInstance().getTMS(28), false);
    }

    public PrintDataRequest<T> Input_String(String left, String mid, String right, int font) {
        return this.Input_String(left, mid, right, font, false);
    }

    public PrintDataRequest<T> Input_String(String left, String mid, String right, boolean multiLine) {
        return this.Input_String(left, mid, right, GlobalPara.getInstance().getTMS(28), multiLine);
    }

    public PrintDataRequest<T> Input_String() {
        return this.Input_String(" ", null, null, GlobalPara.getInstance().getTMS(28), false);
    }

    public PrintDataRequest<T> Input_String(String content, boolean multiLine) {
        return this.Input_String(content, null, null, GlobalPara.getInstance().getTMS(28), multiLine);
    }

    public PrintDataRequest<T> Input_String(String content, int font, boolean multiLine) {
        return this.Input_String(content, null, null, font, multiLine);
    }

    public PrintDataRequest<T> Input_Barcode(String content, String barcodeType) {
        String mapInfo = "0000020000000000" + TradeContent.printCalculate_getX4(this.initWidthDot) + "0001";
        return this.Add_Line_Data("14" + mapInfo + barcodeType + TradeContent.printCalculate_GetBarcodeHex(content.getBytes()) + "04");
    }

    public PrintDataRequest<T> Input_QR(String content) {
        return this.Input_Barcode(content, "0B01030500000000");
    }
}

