/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.print.entity.data;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterPrintThermalException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.exp.MeterWarningException;
import com.jhscale.meter.protocol.print.entity.PrintRequest;
import com.jhscale.meter.protocol.print.entity.PrintResponse;
import com.jhscale.meter.protocol.print.entity.data.PrintTradeRequest;
import com.jhscale.meter.protocol.print.produce.entity.TradePrintResponse;

public class PrintTradeResponse
extends PrintResponse<TradePrintResponse, PrintTradeRequest> {
    private Integer now;
    private Integer total;
    private String state1;
    private String state2;

    @Override
    public void responseBody(TradePrintResponse response, PrintTradeRequest request) {
        response.setBusy('0' == this.state1.charAt(1));
        response.setCache('0' == this.state1.charAt(2));
        response.setPaper('0' == this.state2.charAt(1));
        response.setThermal('0' == this.state2.charAt(2));
        response.setPaperSoon('0' == this.state2.charAt(3));
        response.setPaperErr('0' == this.state2.charAt(4));
        response.setPaperTake('0' == this.state2.charAt(5));
        response.setUnclosed('0' == this.state2.charAt(6));
        response.setNow(request.getNow());
        response.setTotal(request.getTotal());
    }

    @Override
    public void analysis(PrintTradeRequest request) {
        this.state1 = this.toBitval();
        this.state2 = this.toBitval();
        this.now = request.getNow();
        this.total = request.getTotal();
    }

    @Override
    public boolean analysisCheck(PrintRequest request) throws MeterException {
        if ('1' == this.state2.charAt(1)) {
            if (this.hasCache()) {
                throw new MeterException(MeterStateEnum.\u6253\u5370\u7f3a\u7eb8);
            }
            throw new MeterWarningException(MeterStateEnum.\u6253\u5370\u7f3a\u7eb8);
        }
        if ('1' == this.state2.charAt(2)) {
            throw new MeterPrintThermalException(MeterStateEnum.\u6253\u5370\u8fc7\u70ed);
        }
        if ('1' == this.state2.charAt(4)) {
            if (this.hasCache()) {
                throw new MeterException(MeterStateEnum.\u6807\u7b7e\u7eb8\u5f02\u5e38);
            }
            throw new MeterWarningException(MeterStateEnum.\u6807\u7b7e\u7eb8\u5f02\u5e38);
        }
        if ('1' == this.state2.charAt(5)) {
            request.getCommunication().sendDataWithoutAssemble(request);
            throw new MeterWarningException(MeterStateEnum.\u6807\u7b7e\u7eb8\u672a\u62ff\u8d70);
        }
        if ('1' == this.state2.charAt(6)) {
            if (this.hasCache()) {
                throw new MeterException(MeterStateEnum.\u6253\u5370\u673a\u672a\u5173\u95ed);
            }
            throw new MeterWarningException(MeterStateEnum.\u6253\u5370\u673a\u672a\u5173\u95ed);
        }
        return true;
    }

    private boolean hasCache() {
        return '1' == this.state1.charAt(2);
    }

    public boolean finish() {
        return this.now != 0 && this.now == this.total;
    }

    public String getState1() {
        return this.state1;
    }

    public String getState2() {
        return this.state2;
    }

    public Integer getNow() {
        return this.now;
    }

    public void setNow(Integer now) {
        this.now = now;
    }

    public Integer getTotal() {
        return this.total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }
}

