/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.print.entity.file;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.print.entity.PrintRequest;
import com.jhscale.meter.protocol.print.entity.file.PrintFileResponse;
import com.jhscale.meter.utils.FileUtils;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class PrintFileRequest<T extends PrintFileResponse>
extends PrintRequest<T> {
    private File file;
    private String name;
    private InputStream inputStream;
    private List<Integer> nameParams;
    private String hexData;

    public PrintFileRequest() {
    }

    public PrintFileRequest(File file) {
        this.file = file;
    }

    public PrintFileRequest(String name, InputStream inputStream) {
        this.name = name;
        this.inputStream = inputStream;
    }

    public PrintFileRequest(String name, String hexData) {
        this.name = name;
        this.hexData = hexData;
    }

    public PrintFileRequest(String name) {
        this.name = name;
    }

    public void checkUpgradeFile(String upgradeFileName) throws MeterException {
        if (StringUtils.isBlank((CharSequence)upgradeFileName)) {
            throw new MeterException(MeterStateEnum.\u6587\u4ef6\u540d\u65e0\u6548);
        }
    }

    @Override
    public StringBuffer assembler() {
        return super.assembler().append(StringUtils.isNotBlank((CharSequence)this.hexData) ? this.hexData : (Objects.nonNull(this.file) ? FileUtils.fileToHex(this.file) : FileUtils.inputStreamToHex(this.inputStream)));
    }

    public String getUpgradeFileName() {
        return Objects.nonNull(this.file) ? this.file.getName() : this.name;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public List<Integer> getNameParams() {
        if (this.nameParams == null) {
            this.nameParams = new ArrayList<Integer>();
        }
        return this.nameParams;
    }

    public void setNameParams(List<Integer> nameParams) {
        this.nameParams = nameParams;
    }

    public String getHexData() {
        return this.hexData;
    }

    public void setHexData(String hexData) {
        this.hexData = hexData;
    }
}

