/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.print.entity.para;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.print.em.Barcode;
import com.jhscale.meter.protocol.print.em.Dir;
import com.jhscale.meter.protocol.print.em.Grid;
import com.jhscale.meter.protocol.print.em.ParaType;
import com.jhscale.meter.protocol.print.em.StrPara;
import com.jhscale.meter.protocol.print.entity.para.Para;
import com.jhscale.meter.utils.ByteUtils;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class BarCodePara
extends Para {
    private Dir dir = Dir.ZERO;
    private List<StrPara> paras;
    private Grid grid = Grid.Defaul_Grid;
    private Barcode barcode = Barcode.EAN13;
    private String barCode;
    private Integer start_x;
    private Integer start_y;
    private Integer offset_x;
    private Integer offset_y;
    private String content;

    public BarCodePara() {
        super(ParaType.Bar_Code);
    }

    public BarCodePara(String content, Dir dir, Grid grid, Barcode barcode, Integer start_x, Integer start_y, Integer offset_x, Integer offset_y, StrPara ... strParas) {
        this(content, start_x, start_y, offset_x, offset_y);
        this.dir = dir;
        this.paras = Arrays.asList(strParas);
        this.grid = grid;
        this.barcode = barcode;
    }

    public BarCodePara(String content, Dir dir, Grid grid, String barCode, Integer start_x, Integer start_y, Integer offset_x, Integer offset_y, StrPara ... strParas) {
        this(content, start_x, start_y, offset_x, offset_y);
        this.dir = dir;
        this.paras = Arrays.asList(strParas);
        this.grid = grid;
        this.barCode = barCode;
    }

    public BarCodePara(String content, Integer start_x, Integer start_y, Integer offset_x, Integer offset_y) {
        this();
        this.content = content;
        this.start_x = start_x;
        this.start_y = start_y;
        this.offset_x = offset_x;
        this.offset_y = offset_y;
    }

    public BarCodePara set_Dir(Dir dir) {
        this.dir = dir;
        return this;
    }

    public BarCodePara addParas(StrPara ... paras) {
        if (paras != null && paras.length > 0) {
            if (this.paras == null) {
                this.paras = Arrays.asList(paras);
            } else {
                this.paras.addAll(Arrays.asList(paras));
            }
        }
        return this;
    }

    public BarCodePara set_Paras(StrPara ... paras) {
        if (paras != null && paras.length > 0) {
            this.paras = Arrays.asList(paras);
        }
        return this;
    }

    public BarCodePara set_Grid(Grid grid) {
        this.grid = grid;
        return this;
    }

    public BarCodePara set_Barcode(Barcode barcode) {
        this.barcode = barcode;
        return this;
    }

    public BarCodePara set_BarCode(String barCode) throws MeterException {
        if (StringUtils.isBlank((CharSequence)barCode) || barCode.length() != 16) {
            throw new MeterException(MeterStateEnum.\u65e0\u6548\u6761\u7801\u7c7b\u578b);
        }
        this.barCode = barCode;
        return this;
    }

    @Override
    public StringBuffer compile(Charset charset) {
        return super.compile(charset).append(this.dir.getHexVal()).append(super.compileStrPara(this.paras)).append(this.grid.getHexVal()).append("00").append(BarCodePara.to2ByteHex(this.start_x)).append(BarCodePara.to2ByteHex(this.start_y)).append(BarCodePara.to2ByteHex(this.offset_x)).append(BarCodePara.to2ByteHex(this.offset_y)).append(StringUtils.isNotBlank((CharSequence)this.barCode) ? this.barCode : this.barcode.getVal()).append(ByteUtils.toHexString(this.content.getBytes(charset))).append("00");
    }

    public BarCodePara setStartX(Integer start_x) {
        this.start_x = start_x;
        return this;
    }

    public BarCodePara setStartY(Integer start_y) {
        this.start_y = start_y;
        return this;
    }

    public BarCodePara setOffsetX(Integer offset_x) {
        this.offset_x = offset_x;
        return this;
    }

    public BarCodePara setOffsetY(Integer offset_y) {
        this.offset_y = offset_y;
        return this;
    }

    public BarCodePara set_Content(String content) {
        this.content = content;
        return this;
    }

    public Dir getDir() {
        return this.dir;
    }

    public void setDir(Dir dir) {
        this.dir = dir;
    }

    public List<StrPara> getParas() {
        return this.paras;
    }

    public void setParas(List<StrPara> paras) {
        this.paras = paras;
    }

    public Grid getGrid() {
        return this.grid;
    }

    public void setGrid(Grid grid) {
        this.grid = grid;
    }

    public Barcode getBarcode() {
        return this.barcode;
    }

    public void setBarcode(Barcode barcode) {
        this.barcode = barcode;
    }

    public String getBarCode() {
        return this.barCode;
    }

    public void setBarCode(String barCode) {
        this.barCode = barCode;
    }

    public Integer getStart_x() {
        return this.start_x;
    }

    public void setStart_x(Integer start_x) {
        this.start_x = start_x;
    }

    public Integer getStart_y() {
        return this.start_y;
    }

    public void setStart_y(Integer start_y) {
        this.start_y = start_y;
    }

    public Integer getOffset_x() {
        return this.offset_x;
    }

    public void setOffset_x(Integer offset_x) {
        this.offset_x = offset_x;
    }

    public Integer getOffset_y() {
        return this.offset_y;
    }

    public void setOffset_y(Integer offset_y) {
        this.offset_y = offset_y;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }
}

