/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.print.image;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.print.dither.DitherVal;
import com.jhscale.meter.protocol.print.dither.ImageBuffer;
import com.jhscale.meter.protocol.print.em.DotImage;
import com.jhscale.meter.protocol.print.image.DotplotBuilder;
import java.util.Objects;

public class ColorRatioBuilder
extends DotplotBuilder<ColorRatioBuilder> {
    private Double ratio = 0.5;

    public ColorRatioBuilder() {
        super.setDotImage(DotImage.Color);
    }

    public ColorRatioBuilder addRatio(Double ratio) {
        if (Objects.nonNull(ratio)) {
            this.ratio = ratio;
        }
        return this;
    }

    @Override
    protected ColorRatioBuilder check() throws MeterException {
        if (Objects.isNull(this.ratio)) {
            throw new MeterException(MeterStateEnum.Color\u4e34\u754c\u70b9\u767e\u5206\u6bd4\u4e0d\u5b58\u5728);
        }
        return (ColorRatioBuilder)super.check();
    }

    @Override
    protected DitherVal ditherVal() {
        DitherVal ditherVal = new DitherVal();
        ImageBuffer targetBuffer = super.getTargetBuffer();
        ditherVal.setX(targetBuffer.getMinX());
        ditherVal.setY(targetBuffer.getMinY());
        ditherVal.setWidth(targetBuffer.getWidth());
        ditherVal.setHeight(targetBuffer.getHeight());
        int[] data = new int[targetBuffer.getHeight() * targetBuffer.getWidth()];
        ditherVal.setData(data);
        int divide = (int)(-1.6777215E7 * this.ratio);
        int index = 0;
        for (int j = 0; j < targetBuffer.getRgbs().length; ++j) {
            for (int i = 0; i < targetBuffer.getRgbs()[j].length; ++i) {
                data[index] = targetBuffer.getRgbs()[j][i].getPixel() < divide ? 1 : 0;
                ++index;
            }
        }
        return ditherVal;
    }

    @Override
    protected ImageBuffer construct() {
        return super.getSourceBuffer().copy();
    }
}

