/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.print.image;

import com.jhscale.meter.protocol.print.dither.ImageBuffer;
import com.jhscale.meter.protocol.print.image.ImageProcess;
import com.jhscale.meter.protocol.print.image.RGB;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import javax.imageio.ImageIO;

public class DefaultImageProcess
implements ImageProcess {
    @Override
    public RGB readRGB(int pixel) {
        Color color = new Color(pixel, true);
        RGB rgb = new RGB();
        rgb.setPixel(pixel);
        rgb.setAlpha(color.getAlpha());
        rgb.setRI(color.getRed());
        rgb.setRH(Integer.toHexString(color.getRed()));
        rgb.setGI(color.getGreen());
        rgb.setGH(Integer.toHexString(color.getGreen()));
        rgb.setBI(color.getBlue());
        rgb.setBH(Integer.toHexString(color.getBlue()));
        return rgb;
    }

    @Override
    public RGB writeRGB(int red, int green, int blue, int alpha) {
        int pixel = new Color(red, green, blue, alpha).getRGB();
        return this.readRGB(pixel);
    }

    @Override
    public int writeRGB(RGB rgb) {
        return new Color(rgb.getRI(), rgb.getGI(), rgb.getBI(), rgb.getAlpha()).getRGB();
    }

    @Override
    public ImageBuffer readImage(File file) {
        ImageBuffer imageBuffer = null;
        try {
            BufferedImage bufferedImage = ImageIO.read(file);
            imageBuffer = new ImageBuffer();
            imageBuffer.setMinX(bufferedImage.getMinX());
            imageBuffer.setMinY(bufferedImage.getMinY());
            imageBuffer.setWidth(bufferedImage.getWidth());
            imageBuffer.setHeight(bufferedImage.getHeight());
            imageBuffer.setImageSize(bufferedImage.getData().getDataBuffer().getSize());
            imageBuffer.setAbsolutePath(file.getAbsolutePath());
            String name = file.getName();
            imageBuffer.setName(name.substring(0, name.indexOf(".")));
            imageBuffer.setSuffix(name.substring(name.indexOf(".") + 1));
            imageBuffer.setType(bufferedImage.getType());
            RGB[][] RGBS = new RGB[imageBuffer.getHeight()][imageBuffer.getWidth()];
            for (int j = 0; j < imageBuffer.getHeight(); ++j) {
                for (int i = 0; i < imageBuffer.getWidth(); ++i) {
                    RGBS[j][i] = this.readRGB(bufferedImage.getRGB(i, j));
                }
            }
            imageBuffer.setRgbs(RGBS);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return imageBuffer;
    }

    @Override
    public void writeImage(ImageBuffer buffer, File target) {
        BufferedImage bufferedImage = new BufferedImage(buffer.getWidth(), buffer.getHeight(), buffer.getType());
        for (int j = 0; j < buffer.getRgbs().length; ++j) {
            for (int i = 0; i < buffer.getRgbs()[j].length; ++i) {
                RGB rgb = buffer.getRgbs()[j][i];
                bufferedImage.setRGB(i, j, this.writeRGB(Objects.isNull(rgb) ? new RGB() : rgb));
            }
        }
        try {
            File parentFile = target.getParentFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            if (!target.exists()) {
                target.createNewFile();
            }
            ImageIO.write((RenderedImage)bufferedImage, buffer.getSuffix(), target);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public ImageBuffer compress(ImageBuffer buffer, int width, int height) {
        BufferedImage source = new BufferedImage(buffer.getWidth(), buffer.getHeight(), buffer.getType());
        for (int j = 0; j < buffer.getRgbs().length; ++j) {
            for (int i = 0; i < buffer.getRgbs()[j].length; ++i) {
                RGB rgb = buffer.getRgbs()[j][i];
                source.setRGB(i, j, this.writeRGB(Objects.isNull(rgb) ? new RGB() : rgb));
            }
        }
        BufferedImage target = new BufferedImage(width, height, 1);
        target.getGraphics().drawImage(source.getScaledInstance(width, height, 4), 0, 0, null);
        ImageBuffer targetBuffer = new ImageBuffer();
        targetBuffer.setMinX(target.getMinX());
        targetBuffer.setMinY(target.getMinY());
        targetBuffer.setWidth(target.getWidth());
        targetBuffer.setHeight(target.getHeight());
        targetBuffer.setImageSize(target.getData().getDataBuffer().getSize());
        targetBuffer.setName(buffer.getName());
        targetBuffer.setSuffix(buffer.getSuffix());
        targetBuffer.setType(buffer.getType());
        RGB[][] RGBS = new RGB[target.getHeight()][target.getWidth()];
        for (int j = 0; j < target.getHeight(); ++j) {
            for (int i = 0; i < target.getWidth(); ++i) {
                RGBS[j][i] = this.readRGB(target.getRGB(i, j));
            }
        }
        targetBuffer.setRgbs(RGBS);
        return targetBuffer;
    }
}

