/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.print.image;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.print.dither.DitherEnum;
import com.jhscale.meter.protocol.print.dither.DitherVal;
import com.jhscale.meter.protocol.print.dither.IDithering;
import com.jhscale.meter.protocol.print.dither.ImageBuffer;
import com.jhscale.meter.protocol.print.dither.algorithm.Atkinson;
import com.jhscale.meter.protocol.print.dither.algorithm.Burkes;
import com.jhscale.meter.protocol.print.dither.algorithm.FalseFloydSteinberg;
import com.jhscale.meter.protocol.print.dither.algorithm.FloydSteinberg;
import com.jhscale.meter.protocol.print.dither.algorithm.JarvisJudiceNinke;
import com.jhscale.meter.protocol.print.dither.algorithm.Ordered2By2Bayer;
import com.jhscale.meter.protocol.print.dither.algorithm.Ordered3By3Bayer;
import com.jhscale.meter.protocol.print.dither.algorithm.Ordered4By4Bayer;
import com.jhscale.meter.protocol.print.dither.algorithm.Ordered8By8Bayer;
import com.jhscale.meter.protocol.print.dither.algorithm.RandomDithering;
import com.jhscale.meter.protocol.print.dither.algorithm.Sierra;
import com.jhscale.meter.protocol.print.dither.algorithm.SierraLite;
import com.jhscale.meter.protocol.print.dither.algorithm.SimpleLeftToRightErrorDiffusion;
import com.jhscale.meter.protocol.print.dither.algorithm.SimpleThreshold;
import com.jhscale.meter.protocol.print.dither.algorithm.Stucki;
import com.jhscale.meter.protocol.print.dither.algorithm.TwoRowSierra;
import com.jhscale.meter.protocol.print.em.DotImage;
import com.jhscale.meter.protocol.print.image.DotplotBuilder;
import com.jhscale.meter.protocol.print.image.RGB;
import java.util.Objects;

public class DitherBuilder
extends DotplotBuilder<DitherBuilder> {
    private DitherEnum dither = DitherEnum.burkes;
    private Integer ditherThreshold = 128;
    private IDithering dithering;

    public DitherBuilder() {
        super.setDotImage(DotImage.Dither);
    }

    public DitherBuilder addDither(DitherEnum dither) {
        if (Objects.nonNull((Object)dither)) {
            this.dither = dither;
        }
        return this;
    }

    public DitherBuilder addThreshold(Integer threshold) {
        if (Objects.nonNull(threshold)) {
            this.ditherThreshold = threshold;
        }
        return this;
    }

    @Override
    protected DitherBuilder check() throws MeterException {
        if (Objects.isNull((Object)this.dither)) {
            throw new MeterException(MeterStateEnum.Dither\u7b97\u6cd5\u4e0d\u5b58\u5728);
        }
        if (Objects.isNull(this.ditherThreshold)) {
            throw new MeterException(MeterStateEnum.Dither\u4e34\u754c\u503c\u4e0d\u5b58\u5728);
        }
        switch (this.dither) {
            case ordered2By2Bayer: {
                this.dithering = new Ordered2By2Bayer();
                break;
            }
            case ordered3By3Bayer: {
                this.dithering = new Ordered3By3Bayer();
                break;
            }
            case ordered4By4Bayer: {
                this.dithering = new Ordered4By4Bayer();
                break;
            }
            case ordered8By8Bayer: {
                this.dithering = new Ordered8By8Bayer();
                break;
            }
            case floydSteinberg: {
                this.dithering = new FloydSteinberg();
                break;
            }
            case jarvisJudiceNinke: {
                this.dithering = new JarvisJudiceNinke();
                break;
            }
            case sierra: {
                this.dithering = new Sierra();
                break;
            }
            case twoRowSierra: {
                this.dithering = new TwoRowSierra();
                break;
            }
            case sierraLite: {
                this.dithering = new SierraLite();
                break;
            }
            case atkinson: {
                this.dithering = new Atkinson();
                break;
            }
            case stucki: {
                this.dithering = new Stucki();
                break;
            }
            case burkes: {
                this.dithering = new Burkes();
                break;
            }
            case falseFloydSteinberg: {
                this.dithering = new FalseFloydSteinberg();
                break;
            }
            case simpleLeftToRightErrorDiffusion: {
                this.dithering = new SimpleLeftToRightErrorDiffusion();
                break;
            }
            case randomDithering: {
                this.dithering = new RandomDithering();
                break;
            }
            case simpleThreshold: {
                this.dithering = new SimpleThreshold();
                break;
            }
            default: {
                throw new MeterException(MeterStateEnum.Dither\u7b97\u6cd5\u65e0\u6548);
            }
        }
        return (DitherBuilder)super.check();
    }

    @Override
    protected DitherVal ditherVal() {
        DitherVal ditherVal = new DitherVal();
        ImageBuffer targetBuffer = super.getTargetBuffer();
        ditherVal.setX(targetBuffer.getMinX());
        ditherVal.setY(targetBuffer.getMinY());
        ditherVal.setWidth(targetBuffer.getWidth());
        ditherVal.setHeight(targetBuffer.getHeight());
        int[] data = new int[targetBuffer.getHeight() * targetBuffer.getWidth()];
        ditherVal.setData(data);
        int index = 0;
        for (int j = 0; j < targetBuffer.getRgbs().length; ++j) {
            for (int i = 0; i < targetBuffer.getRgbs()[j].length; ++i) {
                RGB rgb = targetBuffer.getRgbs()[j][i];
                data[index] = Objects.isNull(rgb) || rgb.getPixel() == -1 ? 0 : 1;
                ++index;
            }
        }
        return ditherVal;
    }

    @Override
    protected ImageBuffer construct() {
        return this.dithering.dither(super.getSourceBuffer(), super.getImageProcess(), this.ditherThreshold);
    }
}

