/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.print.image;

import com.jhscale.common.model.inter.JSONModel;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.print.dither.ImageBuffer;
import com.jhscale.meter.protocol.print.image.ImageProcess;
import java.io.File;
import java.io.IOException;
import java.util.Objects;

public abstract class ImageBuilder<T extends ImageBuilder>
implements JSONModel {
    private ImageProcess imageProcess;
    private File source;
    private ImageBuffer sourceBuffer;
    private File target;
    private ImageBuffer targetBuffer;

    public T addSource(File source) {
        this.source = source;
        return (T)this;
    }

    public T addSource(ImageBuffer sourceBuffer) {
        this.sourceBuffer = sourceBuffer;
        return (T)this;
    }

    public T addImageProcess(ImageProcess imageProcess) {
        this.imageProcess = imageProcess;
        return (T)this;
    }

    public T addTarget(File target) {
        this.target = target;
        return (T)this;
    }

    protected T check() throws MeterException {
        if (Objects.isNull(this.source) && Objects.isNull(this.sourceBuffer)) {
            throw new MeterException(MeterStateEnum.\u56fe\u7247\u6e90\u6587\u4ef6\u4e3a\u7a7a);
        }
        if (Objects.isNull(this.imageProcess)) {
            throw new MeterException(MeterStateEnum.\u56fe\u7247\u6267\u884c\u5668\u4e0d\u5b58\u5728);
        }
        return (T)this;
    }

    protected T before() throws MeterException {
        this.check();
        if (Objects.isNull(this.sourceBuffer)) {
            this.sourceBuffer = this.imageProcess.readImage(this.source);
        }
        return (T)this;
    }

    public T build() throws MeterException {
        this.before();
        this.targetBuffer = this.construct();
        this.after();
        return (T)this;
    }

    protected abstract ImageBuffer construct();

    protected T after() throws MeterException {
        if (Objects.nonNull(this.target) && Objects.nonNull(this.targetBuffer)) {
            File parentFile = this.target.getParentFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            try {
                if (!this.target.exists()) {
                    this.target.createNewFile();
                }
            }
            catch (IOException e) {
                throw new MeterException(MeterStateEnum.\u521b\u5efa\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25);
            }
            this.imageProcess.writeImage(this.targetBuffer, this.target);
        }
        return (T)this;
    }

    protected ImageProcess getImageProcess() {
        return this.imageProcess;
    }

    public File getSource() {
        return this.source;
    }

    public ImageBuffer getSourceBuffer() {
        return this.sourceBuffer;
    }

    public File getTarget() {
        return this.target;
    }

    public ImageBuffer getTargetBuffer() {
        return this.targetBuffer;
    }
}

