/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.print.line;

import com.jhscale.meter.protocol.print.entity.data.PrintDataRequest;
import com.jhscale.meter.protocol.print.line.PrintLine;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class PrintLineN
implements PrintLine {
    private String content;
    private boolean multiLine = true;
    private Integer font;

    public PrintLineN() {
    }

    public PrintLineN(String content) {
        this.content = content;
    }

    public PrintLineN(String content, boolean multiLine) {
        this.content = content;
        this.multiLine = multiLine;
    }

    public PrintLineN(String content, Integer font) {
        this.content = content;
        this.font = font;
    }

    public PrintLineN(String content, boolean multiLine, Integer font) {
        this.content = content;
        this.multiLine = multiLine;
        this.font = font;
    }

    public static PrintLineN separator(int font) {
        return new PrintLineN("--------------------------------------------", false, font);
    }

    @Override
    public boolean valid() {
        return StringUtils.isNotBlank((CharSequence)this.content);
    }

    @Override
    public PrintLine add(PrintDataRequest request) {
        if (this.valid()) {
            if (Objects.isNull(this.font)) {
                request.Input_String(this.content, this.multiLine);
            } else {
                request.Input_String(this.content, this.font, this.multiLine);
            }
        }
        return this;
    }

    public String getContent() {
        return this.content;
    }

    public PrintLineN setContent(String content) {
        this.content = content;
        return this;
    }

    public boolean isMultiLine() {
        return this.multiLine;
    }

    public PrintLineN setMultiLine(boolean multiLine) {
        this.multiLine = multiLine;
        return this;
    }

    public Integer getFont() {
        return this.font;
    }

    public PrintLineN setFont(Integer font) {
        this.font = font;
        return this;
    }
}

