/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.print.link;

import com.alibaba.fastjson.JSON;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.print.entity.PrintRequest;
import com.jhscale.meter.protocol.print.entity.PrintResponse;
import com.jhscale.meter.protocol.print.link.Messenger;
import com.jhscale.meter.protocol.print.link.ReadReuslt;
import com.jhscale.meter.protocol.print.link.SendResult;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.SerialTool;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.util.Objects;

public class DefaultPrintSerialMessenger
implements Messenger {
    private String portName = "COM3";
    private int baudrate = 115200;
    private SerialPort serialPort;
    private PrintRequest request;
    private PrintResponse response;

    public DefaultPrintSerialMessenger() {
    }

    public DefaultPrintSerialMessenger(String portName, int baudrate) throws MeterException {
        this.portName = portName;
        this.baudrate = baudrate;
        this.serialPortInit();
    }

    @Override
    public SendResult send(String data) {
        return null;
    }

    @Override
    public ReadReuslt read(String communicationLogo) {
        return null;
    }

    @Override
    public boolean effectiveCommunicationTime(String communicationLogo) {
        return false;
    }

    @Override
    public void sendCmd(String cmd, PrintRequest request, PrintResponse response) throws Exception {
        System.out.println(String.format("\u901a\u8baf\u5668[%s]\u53d1\u9001\u547d\u4ee4\uff1a%s", request.getCommunication().getSerial(), cmd));
        if (Objects.isNull(this.serialPort)) {
            this.serialPortInit();
        }
        this.request = request;
        this.response = response;
        long start1 = System.currentTimeMillis();
        byte[] bytes = ByteUtils.fromHexString(cmd);
        long start2 = System.currentTimeMillis();
        SerialTool.sendToPort(this.serialPort, bytes);
        System.out.println("\u6253\u5370\u4e32\u53e3[" + request.getCommunication().getSerial() + "]\u53d1\u9001\u6570\u636e \u8f6c\u6362\u8017\u65f6\uff1a" + (start2 - start1) + " \u53d1\u9001\u8017\u65f6\uff1a " + (System.currentTimeMillis() - start2) + "\uff1b \u6570\u636e\u5185\u5bb9\uff1a" + cmd);
    }

    @Override
    public void sendCmd(byte[] bytes, PrintRequest request, PrintResponse response) throws Exception {
        if (Objects.isNull(this.serialPort)) {
            this.serialPortInit();
        }
        this.request = request;
        this.response = response;
        long start1 = System.currentTimeMillis();
        SerialTool.sendToPort(this.serialPort, bytes);
        System.out.println("\u6253\u5370\u4e32\u53e3\u53d1\u9001\u6570\u636e \u8017\u65f6\uff1a " + (System.currentTimeMillis() - start1) + "\uff1b \u6570\u636e\u5185\u5bb9\uff1a" + JSON.toJSONString((Object)bytes));
    }

    @Override
    public void close() {
        SerialTool.closePort(this.serialPort);
    }

    @Override
    public String identify() {
        return this.portName;
    }

    private void serialPortInit() throws MeterException {
        this.serialPort = SerialTool.openPort(this.portName, this.baudrate);
        SerialTool.addListener(this.serialPort, new SerialPortEventListener(){

            public void serialEvent(SerialPortEvent serialPortEvent) {
                switch (serialPortEvent.getEventType()) {
                    case 10: {
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 9: {
                        break;
                    }
                    case 8: {
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 1: {
                        try {
                            Thread.sleep(50L);
                            String accept = ByteUtils.toHexAscii(SerialTool.readFromPort(DefaultPrintSerialMessenger.this.serialPort));
                            System.out.println(String.format("\u6253\u5370\u4e32\u53e3\u63a5\u53d7\u6570\u636e\uff1a%s", accept));
                            DefaultPrintSerialMessenger.this.response.callBack(accept, DefaultPrintSerialMessenger.this.request);
                            break;
                        }
                        catch (MeterException e) {
                            e.printStackTrace();
                            break;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
    }
}

