/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.print.produce;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.print.PrintFactory;
import com.jhscale.meter.protocol.print.em.PrintParamSave;
import com.jhscale.meter.protocol.print.entity.cmd.Print0000Request;
import com.jhscale.meter.protocol.print.entity.cmd.Print0100Request;
import com.jhscale.meter.protocol.print.entity.cmd.Print0300Request;
import com.jhscale.meter.protocol.print.entity.cmd.Print0400Request;
import com.jhscale.meter.protocol.print.entity.cmd.Print0500Request;
import com.jhscale.meter.protocol.print.entity.cmd.Print0600Request;
import com.jhscale.meter.protocol.print.entity.cmd.Print0700Request;
import com.jhscale.meter.protocol.print.entity.cmd.Print0D00Request;
import com.jhscale.meter.protocol.print.entity.cmd.PrintCmdRequest;
import com.jhscale.meter.protocol.print.link.IPrintBack;
import com.jhscale.meter.protocol.print.produce.IPrintBasic;
import com.jhscale.meter.protocol.print.produce.entity.EntityCard;
import com.jhscale.meter.protocol.print.produce.entity.PrintSetRequest;

public interface IPrintCmd
extends IPrintBasic {
    default public void cmdSend(PrintCmdRequest request) throws MeterException {
        this.send(request);
    }

    default public void getPrintInfo(IPrintBack printBack) throws MeterException {
        Print0000Request request = new Print0000Request();
        request.setPrintBack(printBack);
        this.cmdSend(request);
    }

    default public void setPrintParam(IPrintBack printBack, PrintSetRequest request) throws MeterException {
        Print0100Request print0100Request = new Print0100Request();
        print0100Request.setPrintBack(printBack);
        print0100Request.setItem(request.getItem());
        print0100Request.setSave(request.getSave());
        print0100Request.setVal(request.getVal());
        this.cmdSend(print0100Request);
    }

    default public void setPrintGrayscale(IPrintBack printBack, PrintParamSave save, Integer val) throws MeterException {
        Print0100Request request = new Print0100Request();
        request.setPrintBack(printBack);
        request.setItem(0);
        request.setSave(save);
        request.setVal(val);
        this.cmdSend(request);
    }

    default public void openBox(IPrintBack printBack) throws MeterException {
        Print0300Request request = new Print0300Request();
        request.setPrintBack(printBack);
        this.cmdSend(request);
    }

    default public void readCard(int delay, IPrintBack printBack) throws MeterException {
        Print0400Request request = new Print0400Request();
        request.specify(delay);
        request.setPrintBack(printBack);
        this.cmdSend(request);
    }

    default public void writeCard(EntityCard entityCard, IPrintBack printBack) throws MeterException {
        Print0500Request request = new Print0500Request();
        request.setInnerId(entityCard.getInnerId());
        request.setOuterId(entityCard.getOuterId());
        request.innerHex(PrintFactory.getInstance().obtainRSAEncryptDecrypt());
        request.setPrintBack(printBack);
        this.cmdSend(request);
    }

    default public void countup(EntityCard entityCard, IPrintBack printBack) throws MeterException {
        Print0600Request request = new Print0600Request();
        request.setInnerId(entityCard.getInnerId());
        request.setOuterId(entityCard.getOuterId());
        request.innerHex(PrintFactory.getInstance().obtainRSAEncryptDecrypt());
        request.setPrintBack(printBack);
        this.cmdSend(request);
    }

    default public void readCardNo(int delay, IPrintBack printBack) throws MeterException {
        Print0700Request request = new Print0700Request();
        request.specify(delay);
        request.setPrintBack(printBack);
        this.cmdSend(request);
    }

    default public void paper(char model, IPrintBack printBack) throws MeterException {
        Print0D00Request request = new Print0D00Request();
        request.setModel(model);
        request.setPrintBack(printBack);
        this.cmdSend(request);
    }
}

