/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.print.produce;

import com.jhscale.meter.entity.DeviceReport;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.print.entity.data.PrintDataRequest;
import com.jhscale.meter.protocol.print.entity.para.Para;
import com.jhscale.meter.protocol.print.entity.para.RealBitmapPara;
import com.jhscale.meter.protocol.print.line.PrintLine;
import com.jhscale.meter.protocol.print.link.IPrintBack;
import com.jhscale.meter.protocol.print.produce.IPrintBasic;
import com.jhscale.meter.protocol.print.produce.entity.RealBitmapPrintRequest;
import java.util.Arrays;
import java.util.List;

public interface IPrintData<T extends IPrintData>
extends IPrintBasic {
    default public void printSend(PrintDataRequest request) throws MeterException {
        this.send(request);
    }

    default public T addParas(Para ... paras) throws MeterException {
        if (paras != null && paras.length > 0) {
            this.communication().addParas(Arrays.asList(paras));
        }
        return (T)this;
    }

    default public T addParas(List<Para> paras) throws MeterException {
        if (paras != null && !paras.isEmpty()) {
            this.communication().addParas(paras);
        }
        return (T)this;
    }

    default public T clearParas() throws MeterException {
        this.communication().clearPara();
        return (T)this;
    }

    default public List<Para> getParas() throws MeterException {
        return this.communication().paras();
    }

    default public void printSend(IPrintBack printBack) throws MeterException {
        List<Para> paras = this.getParas();
        if (paras == null || paras.isEmpty()) {
            throw new MeterException(MeterStateEnum.\u6253\u5370\u90e8\u4ef6\u4e0d\u80fd\u4e3a\u7a7a);
        }
        PrintDataRequest request = new PrintDataRequest();
        request.setPrintBack(printBack);
        request.setParas(paras);
        this.send(request);
        this.clearParas();
    }

    default public void printSend(IPrintBack printBack, Para ... paras) throws MeterException {
        if (paras == null || paras.length == 0) {
            throw new MeterException(MeterStateEnum.\u6253\u5370\u90e8\u4ef6\u4e0d\u80fd\u4e3a\u7a7a);
        }
        this.Print_Para(printBack, Arrays.asList(paras));
    }

    default public void Print_Para(IPrintBack printBack, List<Para> paras) throws MeterException {
        if (paras == null || paras.isEmpty()) {
            throw new MeterException(MeterStateEnum.\u6253\u5370\u90e8\u4ef6\u4e0d\u80fd\u4e3a\u7a7a);
        }
        for (Para para : paras) {
            if (!(para instanceof RealBitmapPara)) continue;
            throw new MeterException(MeterStateEnum.\u5b9e\u65f6\u4f4d\u56fe\u4f7f\u7528\u4e13\u7528\u63a5\u53e3);
        }
        PrintDataRequest request = new PrintDataRequest();
        request.setPrintBack(printBack);
        request.setParas(paras);
        this.send(request);
    }

    default public void printSend(IPrintBack printBack, PrintLine ... lines) throws MeterException {
        if (lines == null || lines.length == 0) {
            throw new MeterException(MeterStateEnum.\u884c\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a);
        }
        this.Print_Line(printBack, Arrays.asList(lines));
    }

    default public void Print_Line(IPrintBack printBack, List<PrintLine> lines) throws MeterException {
        if (lines == null || lines.isEmpty()) {
            throw new MeterException(MeterStateEnum.\u884c\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a);
        }
        PrintDataRequest request = new PrintDataRequest();
        for (PrintLine line : lines) {
            if (line == null) continue;
            line.add(request);
        }
        request.setPrintBack(printBack);
        this.send(request);
    }

    @Deprecated
    default public void realBitmapSend(RealBitmapPrintRequest request) throws MeterException {
        throw new MeterException(MeterStateEnum.API\u5e9f\u5f03);
    }

    default public void printReport(IPrintBack printBack, DeviceReport report) throws MeterException {
        this.addParas(report.topPara()).addParas(report.datePara()).addParas(report.splitPara()).addParas(report.innerPara(report.getMoney(), report.getWeight())).addParas(report.splitPara()).addParas(report.cuttingPara());
        this.printSend(printBack);
    }
}

