/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.protocol.print.produce;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.print.entity.bitmap.FileBitMap;
import com.jhscale.meter.protocol.print.entity.file.PrintFileRequest;
import com.jhscale.meter.protocol.print.entity.file.bitmap.PrintBitMapRequest;
import com.jhscale.meter.protocol.print.entity.file.font.PrintFontRequest;
import com.jhscale.meter.protocol.print.entity.file.upgrade.PrintUpgradeRequest;
import com.jhscale.meter.protocol.print.link.IPrintBack;
import com.jhscale.meter.protocol.print.produce.IPrintBasic;
import java.io.File;
import java.io.InputStream;

public interface IPrintUpgrade
extends IPrintBasic {
    default public void fileUpgrade(PrintFileRequest request) throws MeterException {
        this.communication().upgrade(request);
    }

    default public void bitMapUpgrade(PrintBitMapRequest request) throws MeterException {
        this.communication().upgrade(request);
    }

    default public void bitMapUpgrade(IPrintBack printBack, File file) throws MeterException {
        PrintBitMapRequest request = new PrintBitMapRequest(file);
        request.setPrintBack(printBack);
        this.bitMapUpgrade(request);
    }

    default public void bitMapUpgrade(IPrintBack printBack, String name, InputStream inputStream) throws MeterException {
        PrintBitMapRequest request = new PrintBitMapRequest(name, inputStream);
        request.setPrintBack(printBack);
        this.bitMapUpgrade(request);
    }

    default public void bitMapUpgrade(IPrintBack printBack, FileBitMap bitMap) throws MeterException {
        PrintBitMapRequest request = new PrintBitMapRequest(bitMap.getSource().getName(), bitMap.getContent());
        request.setPrintBack(printBack);
        this.bitMapUpgrade(request);
    }

    default public void bitMapUpgrade(IPrintBack printBack, File source, Double rate, Integer number) throws MeterException {
        this.bitMapUpgrade(printBack, ((FileBitMap)((FileBitMap)((FileBitMap)new FileBitMap().addSource(source)).compress(rate)).preterate()).setNumber(number).bulid());
    }

    default public void bitMapUpgrade(IPrintBack printBack, File source, Integer width, Integer height, Integer number) throws MeterException {
        this.bitMapUpgrade(printBack, ((FileBitMap)((FileBitMap)((FileBitMap)new FileBitMap().addSource(source)).compress(width, height)).preterate()).setNumber(number).bulid());
    }

    default public void fontUpgrade(PrintFontRequest request) throws MeterException {
        this.communication().upgrade_all(request);
    }

    default public void fontUpgrade(IPrintBack printBack, File file) throws MeterException {
        PrintFontRequest request = new PrintFontRequest(file);
        request.setPrintBack(printBack);
        this.fontUpgrade(request);
    }

    default public void fontUpgradeCheck(IPrintBack printBack, File file) throws MeterException {
        this.communication().checkUpgrade(this.communication().getUpgradeFileParam(new PrintFontRequest(file)), printBack);
    }

    default public void fontUpgrade(IPrintBack printBack, String name, InputStream inputStream) throws MeterException {
        PrintFontRequest request = new PrintFontRequest(name, inputStream);
        request.setPrintBack(printBack);
        this.fontUpgrade(request);
    }

    default public void fontUpgradeCheck(IPrintBack printBack, String name) throws MeterException {
        this.communication().checkUpgrade(this.communication().getUpgradeFileParam(new PrintFontRequest(name)), printBack);
    }

    default public void versionUpgrade(PrintUpgradeRequest request) throws MeterException {
        this.communication().upgrade(request);
    }

    default public void versionUpgrade(IPrintBack printBack, File file) throws MeterException {
        PrintUpgradeRequest request = new PrintUpgradeRequest(file);
        request.setPrintBack(printBack);
        this.versionUpgrade(request);
    }

    default public void versionUpgradeCheck(IPrintBack printBack, File file) throws MeterException {
        this.communication().checkUpgrade(this.communication().getUpgradeFileParam(new PrintUpgradeRequest(file)), printBack);
    }

    default public void versionUpgrade(IPrintBack printBack, String name, InputStream inputStream) throws MeterException {
        PrintUpgradeRequest request = new PrintUpgradeRequest(name, inputStream);
        request.setPrintBack(printBack);
        this.versionUpgrade(request);
    }

    default public void versionUpgradeCheck(IPrintBack printBack, String name) throws MeterException {
        this.communication().checkUpgrade(this.communication().getUpgradeFileParam(new PrintUpgradeRequest(name)), printBack);
    }
}

