/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.seal;

import com.jhscale.common.utils.SystemtUtils;
import com.jhscale.meter.auncel.AuncelUtils;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.PortManager;
import com.jhscale.meter.io.control.DeviceControl;
import com.jhscale.meter.io.listener.DeviceClientEventListener;
import com.jhscale.meter.model.device.Device;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.seal.SealBLENotify;
import com.jhscale.meter.seal.cmd.HandShakeRequest;
import com.jhscale.meter.seal.cmd.HandShakeResponse;
import com.jhscale.meter.seal.cmd.ObtainStatusRequest;
import com.jhscale.meter.seal.cmd.ObtainStatusResponse;
import com.jhscale.meter.seal.cmd.OpenBLERequest;
import com.jhscale.meter.seal.cmd.OpenBLEResponse;
import com.jhscale.meter.seal.entity.SealRequest;
import com.jhscale.meter.seal.entity.SealResponse;
import com.jhscale.meter.seal.entity.inner.Offset;
import com.jhscale.meter.seal.entity.inner.SealSign;
import com.jhscale.meter.utils.ByteUtils;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang3.StringUtils;

public class SealManager
implements DeviceClientEventListener {
    private Offset offset;
    private PortManager portManager;
    private Timer sealTimer;
    private long timeout = 500L;
    private int recount = 3;
    private long cycle_timeout = 10L;
    private int cycle_count = 100;
    private String cache = "";
    private SealRequest link_request;
    private SealResponse link_response;
    private SealBLENotify bleNotify;
    private boolean ble = false;
    private ObtainStatusResponse statusResponse = null;

    private SealManager() {
    }

    public static SealManager getInstance() {
        return SingleSealManager.SINGLETON;
    }

    public boolean validate() {
        return Objects.nonNull(this.portManager);
    }

    public boolean Init_Manager(DeviceControl control, Device device) throws MeterException {
        if (this.portManager != null) {
            this.close();
        }
        if (Objects.isNull(control)) {
            throw new MeterException(MeterStateEnum.\u63a7\u5236\u5668\u4e0d\u5b58\u5728);
        }
        if (Objects.isNull(device)) {
            throw new MeterException(MeterStateEnum.\u901a\u8baf\u8bbe\u5907\u4e0d\u5b58\u5728);
        }
        this.Execute_Reset();
        this.offset = null;
        this.portManager = new PortManager<Device>(control, device, this);
        boolean result = this.portManager.openPort();
        if (result) {
            this.sealTimer = new Timer();
            this.sealTimer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    SealManager.this.handShake();
                }
            }, 0L, 3600000L);
            SystemtUtils.sleep((int)2);
        }
        return result;
    }

    public SealManager close() throws MeterException {
        if (this.portManager != null) {
            this.portManager.closePort();
            this.portManager = null;
        }
        if (this.sealTimer != null) {
            this.sealTimer.cancel();
            this.sealTimer = null;
        }
        this.Execute_Reset();
        return this;
    }

    public synchronized boolean handShake() {
        if (this.link_request != null || this.ble) {
            return false;
        }
        this.offset = null;
        HandShakeResponse sealResponse = null;
        HandShakeResponse response = null;
        try {
            response = sealResponse = this.execute(new HandShakeRequest());
        }
        catch (Exception e) {
            System.err.printf("%s error%n", Objects.nonNull(sealResponse) ? sealResponse.getClass().getName() : null);
        }
        if (response == null) {
            return false;
        }
        this.offset = new Offset(response.offset1(), response.offset2());
        if (GlobalPara.getInstance().isRunLog()) {
            System.out.printf("\u63e1\u624b\u54cd\u5e94: %s%n\u504f\u79fb\u91cf\uff1a %s%n", response.toJSON(), this.offset.toJSON());
        }
        return true;
    }

    public ObtainStatusResponse status() {
        if (this.portManager == null || this.offset == null) {
            return null;
        }
        if (!this.ble) {
            try {
                ObtainStatusResponse response = this.execute(new ObtainStatusRequest(this.offset));
                this.statusResponse = Objects.nonNull(response) ? response : this.statusResponse;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.statusResponse;
    }

    public OpenBLEResponse openBLE(String unique, SealBLENotify notify) {
        if (this.portManager == null || this.offset == null) {
            return null;
        }
        this.bleNotify = notify;
        try {
            return this.execute(new OpenBLERequest(this.offset).setUnique(unique));
        }
        catch (Exception e) {
            return null;
        }
    }

    public SealManager Execute_Reset() {
        this.link_request = null;
        this.link_response = null;
        this.cache = "";
        this.ble = false;
        return this;
    }

    public Offset getOffset() {
        return this.offset;
    }

    public SealRequest assembly_command(SealRequest request) throws MeterException {
        return request.execute();
    }

    public SealResponse disassembly_command(Offset offset, String command) throws MeterException {
        return (Objects.nonNull(this.link_request) ? new SealResponse(offset, this.link_request, command) : new SealResponse(offset, command)).execute();
    }

    public synchronized <T extends SealRequest, U extends SealResponse> U execute(SealRequest<T, U> request) {
        if (this.ble) {
            return null;
        }
        long timestamp = System.currentTimeMillis();
        SealResponse response = null;
        try {
            String command = this.assembly_command(request).over();
            if (GlobalPara.getInstance().isRunLog()) {
                System.out.printf("%s \u53d1\u9001\u6570\u636e\u5305\uff1a %s %s%n", timestamp, request.getClass().getName(), request.toJSON());
            }
            this.link_request = request;
            this.link_response = null;
            for (int recount = 0; recount < this.recount; ++recount) {
                if (GlobalPara.getInstance().isRunLog()) {
                    System.out.printf("%s \u4e32\u53e3\u53d1\u9001 [%s] \u5185\u5bb9\uff1a \u539f\u59cb\u5185\u5bb9\uff1a[ %s] \u52a0\u5bc6\u5185\u5bb9\uff1a[ %s] \u5b8c\u6574\u6570\u636e\u5305\uff1a[ %s]%n", timestamp, Objects.nonNull(this.offset) ? this.offset.toJSON() : "OFFSET_Null", AuncelUtils.hexPrint(request.getSource_inner().toString()), AuncelUtils.hexPrint(request.getCryption_inner()), AuncelUtils.hexPrint(command));
                }
                this.portManager.writeDataImmediately(ByteUtils.fromHexString(command));
                for (int cycle_count = 0; cycle_count < this.cycle_count; ++cycle_count) {
                    this.cycle_sleep();
                    if (this.link_response == null) continue;
                    response = this.link_response;
                    break;
                }
                if (response == null) {
                    continue;
                }
                break;
            }
        }
        catch (MeterException e) {
            System.err.printf("SealManager_Err: %s%n", e.getMessage());
        }
        return (U)response;
    }

    private void cycle_sleep() {
        try {
            Thread.sleep(this.cycle_timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void onClientEvent(byte[] bytes) throws MeterException {
        long timestamp = System.currentTimeMillis();
        String accept = this.cache + ByteUtils.bytes2HexString(bytes);
        while (StringUtils.isNotBlank((CharSequence)accept)) {
            SealResponse sealResponse;
            int start_index = ByteUtils.indexOf(accept, "02");
            if (start_index == -1) {
                this.cache = "";
                return;
            }
            accept = accept.substring(start_index);
            SealSign sealSign = new SealSign(accept.substring(2, 4));
            int length = sealSign.length();
            if (accept.length() < length) {
                this.cache = accept;
                return;
            }
            String command = accept.substring(0, length);
            accept = accept.substring(length);
            if (GlobalPara.getInstance().isRunLog()) {
                System.out.printf("%s \u4e32\u53e3\u76d1\u542c \u6709\u6548\u6570\u636e\u5305 \u5185\u5bb9 %s%n", timestamp, AuncelUtils.hexPrint(command));
            }
            if ((sealResponse = this.disassembly_command(this.offset, command)) == null) {
                System.err.printf("\u6570\u636e\u5305\u89e3\u6790\u5931\u8d25\uff1a[%s]%n", command);
                continue;
            }
            if (GlobalPara.getInstance().isRunLog()) {
                System.out.printf("%s \u63a5\u53d7\u6570\u636e\u5305\uff1a %s %s%n", timestamp, sealResponse.getClass().getName(), sealResponse.toJSON());
            }
            if (sealResponse instanceof OpenBLEResponse && this.bleNotify != null) {
                this.ble = ((OpenBLEResponse)sealResponse).getResult() == 1;
                this.bleNotify.notify((OpenBLEResponse)sealResponse);
            }
            this.link_response = sealResponse;
        }
    }

    @Override
    public void onClientEventExp(MeterException e) {
        e.printStackTrace();
    }

    private static class SingleSealManager {
        private static final SealManager SINGLETON = new SealManager();

        private SingleSealManager() {
        }
    }
}

