/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.seal.em;

import com.jhscale.meter.seal.cmd.BLEInitRequest;
import com.jhscale.meter.seal.cmd.BLEInitResponse;
import com.jhscale.meter.seal.cmd.BLEObtainStatusRequest;
import com.jhscale.meter.seal.cmd.BLEObtainStatusResponse;
import com.jhscale.meter.seal.cmd.BLEResetRequest;
import com.jhscale.meter.seal.cmd.BLEResetResponse;
import com.jhscale.meter.seal.cmd.CloseBLERequest;
import com.jhscale.meter.seal.cmd.CloseBLEResponse;
import com.jhscale.meter.seal.cmd.HandShakeRequest;
import com.jhscale.meter.seal.cmd.HandShakeResponse;
import com.jhscale.meter.seal.cmd.ObtainStatusRequest;
import com.jhscale.meter.seal.cmd.ObtainStatusResponse;
import com.jhscale.meter.seal.cmd.OpenBLERequest;
import com.jhscale.meter.seal.cmd.OpenBLEResponse;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public enum SealCommand {
    \u534f\u8bae\u63e1\u624b("46", HandShakeRequest.class, HandShakeResponse.class),
    \u8bfb\u53d6\u72b6\u6001(1, "01", ObtainStatusRequest.class, ObtainStatusResponse.class),
    \u6253\u5f00\u84dd\u7259(2, "02", OpenBLERequest.class, OpenBLEResponse.class),
    \u84dd\u7259\u8bfb\u53d6\u72b6\u6001(3, "03", BLEObtainStatusRequest.class, BLEObtainStatusResponse.class),
    \u84dd\u7259\u94c5\u5c01\u590d\u4f4d(4, "04", BLEResetRequest.class, BLEResetResponse.class),
    \u84dd\u7259\u521d\u59cb\u5316(5, "05", BLEInitRequest.class, BLEInitResponse.class),
    \u5173\u95ed\u84dd\u7259(6, "06", CloseBLERequest.class, CloseBLEResponse.class);

    private Integer no;
    private String command;
    private String sign;
    private final Class requestClass;
    private final Class responseClass;

    private SealCommand(String sign, Class requestClass, Class responseClass) {
        this.sign = sign;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    private SealCommand(Integer no, String command, Class requestClass, Class responseClass) {
        this.no = no;
        this.command = command;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    public static SealCommand no(Integer no) {
        if (Objects.nonNull(no)) {
            for (SealCommand value : SealCommand.values()) {
                if (!Objects.nonNull(value.no) || !value.no.equals(no)) continue;
                return value;
            }
        }
        return null;
    }

    public static SealCommand hex(String command, String sign) {
        if (StringUtils.isNotBlank((CharSequence)command) && StringUtils.isNotBlank((CharSequence)sign)) {
            for (SealCommand value : SealCommand.values()) {
                if (!sign.equalsIgnoreCase(value.sign) && !command.equalsIgnoreCase(value.command)) continue;
                return value;
            }
        }
        return null;
    }

    public Integer getNo() {
        return this.no;
    }

    public String getCommand() {
        return StringUtils.isNotBlank((CharSequence)this.command) ? this.command : "";
    }

    public String getSign() {
        return this.sign;
    }

    public Class getRequestClass() {
        return this.requestClass;
    }

    public Class getResponseClass() {
        return this.responseClass;
    }
}

