/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.seal.entity;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.model.base.JSONMeter;
import com.jhscale.meter.seal.em.SealCommand;
import com.jhscale.meter.seal.entity.SealResponse;
import com.jhscale.meter.seal.entity.inner.Offset;
import com.jhscale.meter.seal.entity.inner.SealSign;
import com.jhscale.meter.seal.utils.SealUtils;
import java.lang.reflect.ParameterizedType;

public abstract class SealRequest<T extends SealRequest, U extends SealResponse>
implements JSONMeter {
    protected Offset offset;
    protected SealCommand command;
    protected SealSign sign;
    protected StringBuilder source_inner;
    protected String cryption_inner;
    protected StringBuilder builder;

    public SealRequest() {
    }

    public SealRequest(Offset offset) {
        this.offset = offset;
    }

    public SealRequest(Offset offset, SealCommand command, SealSign sign) {
        this(offset);
        this.command = command;
        this.sign = sign;
    }

    public T execute() throws MeterException {
        this.source_inner = new StringBuilder(this.command.getCommand());
        this.inner_execute();
        this.cryption_inner = SealUtils.encode(this.source_inner.toString(), this.offset);
        String sign = this.sign.appendLength(this.cryption_inner).sign().getBinary();
        String crc = SealUtils.verify(sign + this.cryption_inner);
        this.builder = new StringBuilder().append("02").append(sign).append(this.cryption_inner).append(crc).append("03");
        return (T)this;
    }

    protected abstract void inner_execute();

    public String over() {
        return this.builder.toString();
    }

    public StringBuilder getSource_inner() {
        return this.source_inner;
    }

    public String getCryption_inner() {
        return this.cryption_inner;
    }

    public <U extends SealResponse> Class<U> getResponseClass() {
        ParameterizedType parameterizedType = (ParameterizedType)this.getClass().getGenericSuperclass();
        return (Class)parameterizedType.getActualTypeArguments()[1];
    }
}

