/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.seal.entity;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.seal.em.SealCommand;
import com.jhscale.meter.seal.entity.SealRequest;
import com.jhscale.meter.seal.entity.inner.Offset;
import com.jhscale.meter.seal.entity.inner.SealSign;
import com.jhscale.meter.seal.utils.SealUtils;
import java.util.Objects;

public class SealResponse<T extends SealRequest, U extends SealResponse>
extends SealRequest {
    private T request;

    public SealResponse() {
    }

    public SealResponse(Offset offset, String content) {
        super(offset);
        this.builder = new StringBuilder(content);
    }

    public SealResponse(Offset offset, T request, String content) {
        this(offset, content);
        this.request = request;
    }

    public U execute() throws MeterException {
        String crc_data;
        this.sign = new SealSign(this.builder.substring(2, 4));
        int inner_length = this.sign.inner_length();
        String crc_content = this.builder.substring(2, 4 + inner_length);
        String crc_count = SealUtils.verify(crc_content);
        if (!crc_count.equalsIgnoreCase(crc_data = this.builder.substring(this.builder.length() - 4, this.builder.length() - 2))) {
            System.err.printf("crc_content:[%s] crc_count:[%s] crc_data[%s]%n", crc_content, crc_count, crc_data);
            throw new MeterException(MeterStateEnum.SL_CRC\u68c0\u67e5\u9519\u8bef);
        }
        this.cryption_inner = crc_content.substring(2);
        this.source_inner = new StringBuilder().append(SealUtils.decode(this.cryption_inner, this.offset));
        String command_hex = this.source_inner.substring(0, 2);
        this.command = SealCommand.hex(command_hex, this.sign.getBinary());
        SealResponse u = this;
        try {
            Class clazz = Objects.nonNull(this.request) ? ((SealRequest)this.request).getResponseClass() : this.command.getResponseClass();
            u = (SealResponse)clazz.newInstance();
            u.command = this.command;
            u.sign = this.sign;
            u.builder = this.builder;
            u.source_inner = this.source_inner;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        u.inner_execute();
        return (U)u;
    }

    @Override
    protected void inner_execute() {
    }

    public T getRequest() {
        return this.request;
    }

    public void setRequest(T request) {
        this.request = request;
    }
}

