/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.seal.entity.inner;

import com.jhscale.meter.model.base.JSONMeter;
import com.jhscale.meter.seal.em.SealACK;
import com.jhscale.meter.seal.em.SealCMD;
import com.jhscale.meter.seal.utils.SealUtils;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.MQTTUtils;

public class SealSign
implements JSONMeter {
    private String binary;
    private SealCMD cmd;
    private SealACK ack;
    private int length;

    public SealSign() {
    }

    public SealSign(SealCMD cmd, SealACK ack) {
        this.cmd = cmd;
        this.ack = ack;
    }

    public SealSign(String sign) {
        this.binary = sign;
        String binary = MQTTUtils.hex2Bit(sign);
        this.cmd = SealCMD.cmd(binary.charAt(0));
        this.ack = SealACK.ack(binary.charAt(1));
        this.length = Integer.parseInt(binary.substring(2), 2);
    }

    public SealSign appendLength(String cryption_inner) {
        this.length = cryption_inner.length() / 2;
        return this;
    }

    public SealSign sign() {
        String binary = String.format("%s%s%s", this.cmd.getCmd(), this.ack.getAck(), SealUtils.length(this.length + 4));
        this.binary = ByteUtils.dataFormat(binary);
        return this;
    }

    public int inner_length() {
        return (this.length - 4) * 2;
    }

    public int length() {
        return this.length * 2;
    }

    public String getBinary() {
        return this.binary;
    }

    public void setBinary(String binary) {
        this.binary = binary;
    }

    public SealCMD getCmd() {
        return this.cmd;
    }

    public void setCmd(SealCMD cmd) {
        this.cmd = cmd;
    }

    public SealACK getAck() {
        return this.ack;
    }

    public void setAck(SealACK ack) {
        this.ack = ack;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }
}

