/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.seal.listener;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.listener.DeviceClientEventListener;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.protocol.IBProtocolResponse;
import com.jhscale.meter.protocol.IDebugProtocolResponse;
import com.jhscale.meter.protocol.IOProtocolResponse;
import com.jhscale.meter.protocol.IProtocolManager;
import com.jhscale.meter.protocol.IProtocolResponse;
import com.jhscale.meter.protocol.ad.em.CommunicationState;
import com.jhscale.meter.protocol.ad.entity.ADPackDisassemblyRequest;
import com.jhscale.meter.protocol.ad.entity.ADPackDisassemblyResponse;
import com.jhscale.meter.protocol.ad.send.ADAsynEvent;
import com.jhscale.meter.protocol.ad.send.ADReadAsynThread;
import com.jhscale.meter.protocol.entity.ProtocolEntity;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.CodeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SealClientEventListener
implements DeviceClientEventListener,
ADAsynEvent {
    CommunicationState communication = CommunicationState.NORMAL;
    IBProtocolResponse defaultResponse;
    IProtocolManager manager;
    Map<String, ProtocolEntity> responseMap;
    private ADReadAsynThread readAsynThread;

    public SealClientEventListener(IBProtocolResponse defaultResponse, IProtocolManager manager) {
        this.defaultResponse = defaultResponse;
        this.manager = manager;
        this.responseMap = new HashMap<String, ProtocolEntity>();
        this.readAsynThread = new ADReadAsynThread(this);
        this.readAsynThread.switchOn();
        this.readAsynThread.start();
    }

    @Override
    public void onClientEvent(byte[] bytes) throws MeterException {
        boolean other;
        boolean bl = other = this.defaultResponse != null && this.defaultResponse instanceof IOProtocolResponse;
        if (other) {
            ((IOProtocolResponse)this.defaultResponse).target(bytes);
        } else {
            boolean debug;
            boolean bl2 = debug = this.defaultResponse != null && this.defaultResponse instanceof IDebugProtocolResponse;
            if (bytes != null && bytes.length > 0) {
                if (debug) {
                    ((IDebugProtocolResponse)this.defaultResponse).source(bytes);
                }
                byte[] decode = CodeUtils.decode(bytes);
                if (debug) {
                    ((IDebugProtocolResponse)this.defaultResponse).target(decode);
                }
                this.addBuffer(decode);
            }
        }
    }

    @Override
    public IBProtocolResponse defaultResponse() {
        return this.defaultResponse;
    }

    @Override
    public byte[] execute(byte[] buffer) {
        int index;
        block14: {
            if (buffer[0] != 2) {
                boolean has_prefix = false;
                for (int i = 0; i < buffer.length; ++i) {
                    if (buffer[i] != 2) continue;
                    has_prefix = true;
                    buffer = Arrays.copyOfRange(buffer, i, buffer.length);
                    break;
                }
                if (!has_prefix) {
                    return new byte[0];
                }
            }
            ArrayList<byte[]> bytes = new ArrayList<byte[]>();
            index = 0;
            for (int i = 0; i < buffer.length; ++i) {
                byte[] copy;
                if (buffer[i] != 3) continue;
                if (i + 1 != buffer.length && buffer[i + 1] == 2) {
                    bytes.add(Arrays.copyOfRange(buffer, index, i + 1));
                    index = i + 1;
                    continue;
                }
                if (i + 1 != buffer.length || Integer.parseInt(ByteUtils.toHexString(Arrays.copyOfRange(copy = Arrays.copyOfRange(buffer, index, i + 1), 1, 2)), 16) + 5 != copy.length) continue;
                bytes.add(copy);
                index = i + 1;
            }
            try {
                if (!bytes.isEmpty()) {
                    for (byte[] aByte : bytes) {
                        ADPackDisassemblyResponse response;
                        ProtocolEntity protocolEntity;
                        if (GlobalPara.getInstance().isRunLog()) {
                            System.out.println("\u89e3\u6790\uff1a" + ByteUtils.toHexString(aByte));
                        }
                        if ((protocolEntity = this.responseMap.remove((response = (ADPackDisassemblyResponse)this.manager.execute(new ADPackDisassemblyRequest(aByte))).KEY())) != null && protocolEntity.getResponse() instanceof IProtocolResponse) {
                            ((IProtocolResponse)protocolEntity.getResponse()).target(response);
                            continue;
                        }
                        if (this.defaultResponse != null && this.defaultResponse instanceof IProtocolResponse) {
                            ((IProtocolResponse)this.defaultResponse).target(response);
                            continue;
                        }
                        throw new MeterException(MeterStateEnum.AD_\u54cd\u5e94\u901a\u9053\u5bf9\u8c61\u5f02\u5e38);
                    }
                }
            }
            catch (MeterException e) {
                e.printStackTrace();
                JLog.error("AD Parse error\uff1a{}", e.getMessage(), e);
                if (this.defaultResponse != null) {
                    this.defaultResponse.exp(e);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                JLog.error("AD Parse Exception\uff1a{}", e.getMessage(), e);
                if (this.defaultResponse == null) break block14;
                this.defaultResponse.exp(new MeterException(e, MeterStateEnum.\u5176\u4ed6\u672a\u77e5\u5f02\u5e38));
            }
        }
        return Arrays.copyOfRange(buffer, index, buffer.length);
    }

    @Override
    public void addBuffer(byte[] bytes) {
        this.readAsynThread.addBuffer(bytes);
    }

    @Override
    public void clear() {
        this.readAsynThread.clear();
    }

    @Override
    public synchronized void expireCheck() {
        try {
            if (this.responseMap != null && !this.responseMap.isEmpty()) {
                Iterator<Map.Entry<String, ProtocolEntity>> iterator = this.responseMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, ProtocolEntity> entry = iterator.next();
                    if (entry.getValue() != null && !entry.getValue().expire(10000)) continue;
                    iterator.remove();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onClientEventExp(MeterException e) {
        if (this.defaultResponse != null) {
            this.defaultResponse.exp(e);
        }
    }

    @Override
    public synchronized void addProtocolResponse(String key, ProtocolEntity response) {
        this.responseMap.put(key, response);
    }

    @Override
    public void stop() {
        this.readAsynThread.giveOver();
    }

    @Override
    public synchronized void setCommunication(CommunicationState communication) {
        this.communication = communication;
        this.readAsynThread.switchOn();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.readAsynThread.switchOn();
    }

    @Override
    public CommunicationState getCommunication() {
        return this.communication;
    }
}

