/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.seal.utils;

import com.jhscale.meter.seal.entity.inner.Offset;
import com.jhscale.meter.utils.ByteUtils;
import java.util.Objects;

public class SealUtils {
    public static final int[] codeArr = new int[]{224, 18, 197, 184, 42, 14, 35, 37, 0, 88, 214, 76, 143, 209, 101, 82, 106, 225, 204, 212, 16, 116, 114, 154, 20, 109, 77, 124, 79, 237, 200, 239, 199, 44, 241, 54, 120, 45, 150, 103, 48, 112, 233, 156, 206, 185, 144, 198, 4, 80, 97, 75, 161, 138, 69, 7, 157, 93, 158, 153, 242, 228, 147, 129, 218, 91, 230, 132, 73, 2, 168, 23, 160, 178, 162, 222, 208, 17, 244, 221, 140, 251, 250, 232, 135, 169, 105, 55, 201, 152, 145, 108, 61, 207, 243, 172, 165, 8, 236, 51, 193, 15, 87, 57, 32, 211, 27, 128, 71, 139, 118, 31, 89, 102, 183, 179, 41, 238, 163, 81, 66, 24, 133, 254, 10, 130, 247, 94, 40, 137, 125, 21, 63, 182, 159, 227, 235, 219, 90, 123, 127, 148, 6, 191, 19, 245, 33, 121, 53, 155, 146, 142, 202, 9, 50, 249, 46, 12, 28, 215, 58, 56, 78, 180, 213, 186, 119, 64, 226, 229, 1, 253, 134, 59, 223, 246, 104, 84, 98, 70, 166, 30, 252, 95, 217, 188, 192, 122, 85, 92, 110, 11, 136, 126, 170, 177, 248, 149, 113, 190, 111, 176, 173, 49, 167, 210, 68, 52, 220, 13, 115, 189, 181, 175, 60, 25, 86, 34, 194, 107, 205, 141, 100, 255, 65, 5, 240, 36, 174, 234, 29, 43, 74, 96, 117, 47, 187, 195, 216, 26, 203, 39, 3, 67, 62, 99, 131, 83, 38, 22, 72, 151, 164, 171, 196, 231};
    public static final int[] decodeArr = new int[]{8, 170, 69, 242, 48, 225, 142, 55, 97, 153, 124, 191, 157, 209, 5, 101, 20, 77, 1, 144, 24, 131, 249, 71, 121, 215, 239, 106, 158, 230, 181, 111, 104, 146, 217, 6, 227, 7, 248, 241, 128, 116, 4, 231, 33, 37, 156, 235, 40, 203, 154, 99, 207, 148, 35, 87, 161, 103, 160, 173, 214, 92, 244, 132, 167, 224, 120, 243, 206, 54, 179, 108, 250, 68, 232, 51, 11, 26, 162, 28, 49, 119, 15, 247, 177, 188, 216, 102, 9, 112, 138, 65, 189, 57, 127, 183, 233, 50, 178, 245, 222, 14, 113, 39, 176, 86, 16, 219, 91, 25, 190, 200, 41, 198, 22, 210, 21, 234, 110, 166, 36, 147, 187, 139, 27, 130, 193, 140, 107, 63, 125, 246, 67, 122, 172, 84, 192, 129, 53, 109, 80, 221, 151, 12, 46, 90, 150, 62, 141, 197, 38, 251, 89, 59, 23, 149, 43, 56, 58, 134, 72, 52, 74, 118, 252, 96, 180, 204, 70, 85, 194, 253, 95, 202, 228, 213, 201, 195, 73, 115, 163, 212, 133, 114, 3, 45, 165, 236, 185, 211, 199, 143, 186, 100, 218, 237, 254, 2, 47, 32, 30, 88, 152, 240, 18, 220, 44, 93, 76, 13, 205, 105, 19, 164, 10, 159, 238, 184, 64, 137, 208, 79, 75, 174, 0, 17, 168, 135, 61, 169, 66, 255, 83, 42, 229, 136, 98, 29, 117, 31, 226, 34, 60, 94, 78, 145, 175, 126, 196, 155, 82, 81, 182, 171, 123, 223};
    private static Integer nid;

    public static String length(int innerLength) {
        return ByteUtils.ten2two(innerLength, 6);
    }

    public static String verify(String content) {
        int val = 0;
        for (int i = 0; i < content.length(); i += 2) {
            val += ByteUtils.hex2Ten(content.substring(i, i + 2));
        }
        val = 255 - val % 256;
        return ByteUtils.int2Hex(val);
    }

    public static synchronized int nid() {
        nid = nid == null ? Integer.valueOf((int)(Math.random() * 255.0)) : Integer.valueOf(nid + 1);
        return nid;
    }

    public static String encode(String command, Offset offset) {
        if (Objects.nonNull(offset)) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < command.length(); i += 2) {
                int c = ByteUtils.hex2Ten(command.substring(i, i + 2));
                int hex = codeArr[(c + offset.getS1()) % 256];
                builder.append(ByteUtils.int2Hex(hex));
            }
            command = builder.toString();
        }
        return command;
    }

    public static String decode(String command, Offset offset) {
        if (Objects.nonNull(offset)) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < command.length(); i += 2) {
                int c = ByteUtils.hex2Ten(command.substring(i, i + 2));
                int hex = (decodeArr[c] - offset.getS2()) % 256;
                builder.append(ByteUtils.int2Hex(hex));
            }
            command = builder.toString();
        }
        return command;
    }
}

