/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.tool.barcode;

import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.meter.em.PayCode;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.model.BarCodeItemResult;
import com.jhscale.meter.protocol.model.BarCodeItemSearch;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.tool.barcode.em.Commodity;
import com.jhscale.meter.tool.barcode.entity.BarCodeInfo;
import com.jhscale.meter.tool.barcode.entity.CashierResult;
import com.jhscale.meter.tool.barcode.entity.CommodityResult;
import com.jhscale.meter.tool.barcode.entity.PLUNumberNoConstant;
import com.jhscale.meter.tool.barcode.entity.PLUSpecsItem;
import com.jhscale.meter.tool.barcode.entity.PLUSpecsParam;
import com.jhscale.meter.tool.barcode.entity.Rule;
import com.jhscale.meter.tool.barcode.loader.BarCodeLoader;
import com.jhscale.meter.tool.barcode.loader.CashierCodeLoader;
import com.jhscale.meter.tool.barcode.loader.JKYPayCodeLoader;
import com.jhscale.meter.tool.barcode.loader.PLUSpecsLoader;
import com.jhscale.meter.tool.barcode.loader.rule.CashierCode;
import com.jhscale.meter.tool.barcode.loader.rule.CashierCode_13_1;
import com.jhscale.meter.tool.barcode.loader.rule.CashierCode_13_2;
import com.jhscale.meter.tool.barcode.loader.rule.CashierCode_13_3;
import com.jhscale.meter.tool.barcode.loader.rule.CashierCode_13_4;
import com.jhscale.meter.tool.barcode.loader.rule.CashierCode_13_5;
import com.jhscale.meter.tool.barcode.loader.rule.CashierCode_18_1;
import com.jhscale.meter.tool.barcode.loader.rule.CashierCode_18_2;
import com.jhscale.meter.tool.barcode.loader.rule.CashierCode_18_3;
import com.jhscale.meter.tool.barcode.loader.rule.CashierCode_18_4;
import com.jhscale.meter.tool.barcode.loader.rule.CashierCode_18_5;
import com.jhscale.meter.utils.Constant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class BarCodeFactory
extends JSONModel {
    private JKYPayCodeLoader jkyPayCodeLoader;
    private CashierCode cashierCode;
    private static Map<Integer, CashierCode> cashierCodeMap;
    private static final String WX_PAY_REGULAR = "^1[0-5]\\d{16}$";
    private static final String ALI_PAY_REGULAR = "^(?:2[5-9]|30)\\d{14,18}$";

    private BarCodeFactory() {
    }

    public static BarCodeFactory getInstance() {
        return SingletonFactory.INSTANCE;
    }

    private static Map<Integer, CashierCode> cashierCode() {
        cashierCodeMap = new HashMap<Integer, CashierCode>();
        CashierCode_13_1 cashierCode_13_1 = new CashierCode_13_1();
        cashierCodeMap.put(cashierCode_13_1.sn(), cashierCode_13_1);
        CashierCode_13_2 cashierCode_13_2 = new CashierCode_13_2();
        cashierCodeMap.put(cashierCode_13_2.sn(), cashierCode_13_2);
        CashierCode_13_3 cashierCode_13_3 = new CashierCode_13_3();
        cashierCodeMap.put(cashierCode_13_3.sn(), cashierCode_13_3);
        CashierCode_13_4 cashierCode_13_4 = new CashierCode_13_4();
        cashierCodeMap.put(cashierCode_13_4.sn(), cashierCode_13_4);
        CashierCode_13_5 cashierCode_13_5 = new CashierCode_13_5();
        cashierCodeMap.put(cashierCode_13_5.sn(), cashierCode_13_5);
        CashierCode_18_1 cashierCode_18_1 = new CashierCode_18_1();
        cashierCodeMap.put(cashierCode_18_1.sn(), cashierCode_18_1);
        CashierCode_18_2 cashierCode_18_2 = new CashierCode_18_2();
        cashierCodeMap.put(cashierCode_18_2.sn(), cashierCode_18_2);
        CashierCode_18_3 cashierCode_18_3 = new CashierCode_18_3();
        cashierCodeMap.put(cashierCode_18_3.sn(), cashierCode_18_3);
        CashierCode_18_4 cashierCode_18_4 = new CashierCode_18_4();
        cashierCodeMap.put(cashierCode_18_4.sn(), cashierCode_18_4);
        CashierCode_18_5 cashierCode_18_5 = new CashierCode_18_5();
        cashierCodeMap.put(cashierCode_18_5.sn(), cashierCode_18_5);
        return cashierCodeMap;
    }

    public BarCodeFactory build(BarCodeLoader ... loaders) throws MeterException {
        if (loaders != null && loaders.length > 0) {
            for (BarCodeLoader loader : loaders) {
                if (loader instanceof JKYPayCodeLoader) {
                    this.jkyPayCodeLoader = (JKYPayCodeLoader)loader;
                    continue;
                }
                if (!(loader instanceof CashierCodeLoader)) continue;
                this.cashierCode = cashierCodeMap.get(((CashierCodeLoader)loader).getRule().serialNo());
                if (this.cashierCode == null) {
                    throw new MeterException(MeterStateEnum.\u52a0\u8f7d\u96c6\u4e2d\u6536\u94f6\u5931\u8d25);
                }
                this.cashierCode.setRule(((CashierCodeLoader)loader).getRule());
            }
        }
        return this;
    }

    public PayCode payCode(String code) {
        if (Pattern.matches(WX_PAY_REGULAR, code)) {
            return PayCode.WECHAT_PAY;
        }
        if (Pattern.matches(ALI_PAY_REGULAR, code)) {
            return PayCode.ALI_PAY;
        }
        if (Objects.nonNull(this.jkyPayCodeLoader) && Pattern.matches(this.jkyPayCodeLoader.regular(), code)) {
            return PayCode.JK_PAY;
        }
        return PayCode.UNION_PAY;
    }

    @Deprecated
    public CommodityResult commodityParse(String code) {
        if (StringUtils.isNotBlank((CharSequence)code) && Objects.nonNull((Object)this.cashierCode) && this.cashierCode.checkLength(code) && this.cashierCode.checkPart1(code)) {
            BarCodeInfo barCodeInfo = new BarCodeInfo();
            barCodeInfo.setPart2(this.cashierCode.getRule().getPart2());
            this.cashierCode.parse(code, barCodeInfo);
            return new CommodityResult(Commodity.\u6536\u94f6\u6761\u7801.getType(), code, barCodeInfo);
        }
        return new CommodityResult(Commodity.\u666e\u901a\u6761\u7801.getType(), code, null);
    }

    @Deprecated
    public CashierResult commodityComplete(BarCodeInfo barCodeInfo, PLUSpecsParam pluSpecsParam) {
        if (barCodeInfo != null && Objects.nonNull((Object)this.cashierCode)) {
            if (pluSpecsParam != null) {
                this.cashierCode.complete(barCodeInfo, pluSpecsParam.getUnit(), pluSpecsParam.getPrice());
            }
            return new CashierResult(Commodity.\u6536\u94f6\u6761\u7801.getType(), barCodeInfo, barCodeInfo.pluNumberNoConstant(), pluSpecsParam, barCodeInfo.getAmount(), barCodeInfo.getWeight(), barCodeInfo.getPrice(), barCodeInfo.getTotal());
        }
        return new CashierResult(Commodity.\u666e\u901a\u6761\u7801.getType());
    }

    @Deprecated
    public CashierResult commodity(String code, PLUSpecsLoader pluSpecsLoader) {
        CommodityResult commodityResult = this.commodityParse(code);
        if (commodityResult.getType() == Commodity.\u6536\u94f6\u6761\u7801.getType()) {
            if (pluSpecsLoader != null) {
                return this.commodityComplete(commodityResult.getBarCodeInfo(), pluSpecsLoader.queryPLUSpecsByNumberOrNoOrConstant(commodityResult.getBarCodeInfo().pluNumberNoConstant()));
            }
            return new CashierResult(Commodity.\u6536\u94f6\u6761\u7801.getType(), code, commodityResult.getBarCodeInfo());
        }
        return new CashierResult(Commodity.\u666e\u901a\u6761\u7801.getType(), code);
    }

    @Deprecated
    public String commodityAssemble(PLUSpecsItem item) throws MeterException {
        if (Objects.nonNull((Object)item) && Objects.nonNull((Object)this.cashierCode)) {
            return new StringBuffer().append(this.cashierCode.getRule().getPart1()).append(this.cashierCode.addPart2(item)).append(this.cashierCode.addPart3(item)).append(this.cashierCode.addPart4(item)).append(this.cashierCode.addVerify()).toString();
        }
        throw new MeterException(MeterStateEnum.\u52a0\u89e3\u5bc6\u6a21\u5757\u672a\u521d\u59cb\u5316);
    }

    @Deprecated
    public BarCodeFactory cashierCodeLoader_13_1(Rule rule) throws MeterException {
        rule.setEan(13);
        rule.setNo(1);
        return this.build(new CashierCodeLoader(rule));
    }

    @Deprecated
    public BarCodeFactory cashierCodeLoader_18_1(Rule rule) throws MeterException {
        rule.setEan(18);
        rule.setNo(1);
        return this.build(new CashierCodeLoader(rule));
    }

    public CashierResult Commodity_Format(String code, PLUSpecsLoader pluSpecsLoader) throws MeterException {
        if (StringUtils.isBlank((CharSequence)code)) {
            return new CashierResult(Commodity.\u666e\u901a\u6761\u7801.getType(), code);
        }
        BarCodeItemResult barCodeItemResult = BarCodeItemSearch.Calulate(code);
        if (barCodeItemResult == null || !barCodeItemResult.isOK()) {
            return new CashierResult(Commodity.\u666e\u901a\u6761\u7801.getType(), code);
        }
        Integer pluNo = barCodeItemResult.getNumber();
        Integer number = barCodeItemResult.getItemcode();
        PLUNumberNoConstant pluNumberNoConstant = null;
        if (Objects.nonNull(pluNo)) {
            pluNumberNoConstant = new PLUNumberNoConstant(null, pluNo, null);
        } else if (Objects.nonNull(number)) {
            if (number == 0) {
                int Scanner_0Note_Deal = GlobalPara.getInstance().getTMS(121);
                if (Scanner_0Note_Deal == 1) {
                    pluNumberNoConstant = new PLUNumberNoConstant(null, Constant.TEMP_Weight, null);
                } else if (Scanner_0Note_Deal == 2) {
                    pluNumberNoConstant = new PLUNumberNoConstant(null, Constant.TEMP_PCS, null);
                }
            } else {
                pluNumberNoConstant = new PLUNumberNoConstant(number, null, null);
            }
        }
        if (Objects.isNull(pluNumberNoConstant)) {
            return new CashierResult(Commodity.\u666e\u901a\u6761\u7801.getType(), code);
        }
        if (Objects.isNull(pluSpecsLoader)) {
            return new CashierResult(Commodity.\u6536\u94f6\u6761\u7801.getType(), code, barCodeItemResult, pluNumberNoConstant);
        }
        PLUSpecsParam pluSpecsParam = pluSpecsLoader.queryPLUSpecsByNumberOrNoOrConstant(pluNumberNoConstant);
        if (Objects.isNull((Object)pluSpecsParam)) {
            return new CashierResult(Commodity.\u6536\u94f6\u6761\u7801.getType(), code, barCodeItemResult, pluNumberNoConstant);
        }
        return new CashierResult(Commodity.\u6536\u94f6\u6761\u7801.getType(), code, barCodeItemResult, pluNumberNoConstant, pluSpecsParam);
    }

    static {
        BarCodeFactory.cashierCode();
    }

    private static class SingletonFactory {
        private static BarCodeFactory INSTANCE = new BarCodeFactory();

        private SingletonFactory() {
        }
    }
}

