/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.tool.barcode.entity;

import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.common.ysscale.UnitEnum;
import com.jhscale.meter.tool.barcode.entity.PLUNumberNoConstant;
import com.jhscale.meter.tool.barcode.entity.Rule;
import java.math.BigDecimal;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class BarCodeInfo
extends JSONModel {
    private int part2;
    private int number;
    private int pluNo;
    private String constant;
    private String val;
    private BigDecimal amount;
    private BigDecimal weight;
    private BigDecimal price;
    private BigDecimal total;

    public BarCodeInfo labelUnitAndPrice(Rule rule, int unit, BigDecimal price) {
        this.price = price.setScale(rule.getMoney(), rule.getRound());
        String val = String.valueOf(unit);
        if (Objects.nonNull(this.total)) {
            if (val.equalsIgnoreCase(UnitEnum.\u8ba1\u91cd.getVal())) {
                this.weight = this.total.divide(price, rule.getWeight(), rule.getRound());
            } else if (val.equalsIgnoreCase(UnitEnum.\u8ba1\u4ef6.getVal())) {
                this.amount = this.total.divide(price, rule.getAmount(), rule.getRound());
            }
        } else if (StringUtils.isNotBlank((CharSequence)this.val)) {
            if (val.equalsIgnoreCase(UnitEnum.\u8ba1\u91cd.getVal())) {
                this.weight = rule.convertWeight(this.val);
                this.total = this.price.multiply(this.weight).setScale(rule.getMoney(), rule.getRound());
            } else if (val.equalsIgnoreCase(UnitEnum.\u8ba1\u4ef6.getVal())) {
                this.amount = rule.convertAmount(this.val);
                this.total = this.price.multiply(this.amount).setScale(rule.getMoney(), rule.getRound());
            }
        }
        return this;
    }

    public BarCodeInfo labelUnit(Rule rule, int unit) {
        String val = String.valueOf(unit);
        if (val.equalsIgnoreCase(UnitEnum.\u8ba1\u91cd.getVal())) {
            this.weight = rule.convertWeight(this.val);
            this.price = this.total.divide(this.weight, rule.getMoney(), rule.getRound());
        } else if (val.equalsIgnoreCase(UnitEnum.\u8ba1\u4ef6.getVal())) {
            this.amount = rule.convertAmount(this.val);
            this.price = this.total.divide(this.amount, rule.getMoney(), rule.getRound());
        }
        return this;
    }

    public BigDecimal weightOrAmount() {
        return Objects.nonNull(this.weight) ? this.weight : this.amount;
    }

    public PLUNumberNoConstant pluNumberNoConstant() {
        return new PLUNumberNoConstant(this.number, this.pluNo, this.constant);
    }

    public int getPart2() {
        return this.part2;
    }

    public void setPart2(int part2) {
        this.part2 = part2;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public int getPluNo() {
        return this.pluNo;
    }

    public void setPluNo(int pluNo) {
        this.pluNo = pluNo;
    }

    public String getConstant() {
        return this.constant;
    }

    public void setConstant(String constant) {
        this.constant = constant;
    }

    public String getVal() {
        return this.val;
    }

    public void setVal(String val) {
        this.val = val;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public BigDecimal getWeight() {
        return this.weight;
    }

    public void setWeight(BigDecimal weight) {
        this.weight = weight;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getTotal() {
        return this.total;
    }

    public void setTotal(BigDecimal total) {
        this.total = total;
    }
}

