/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.tool.barcode.entity;

import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.meter.utils.BigDecimalUtils;
import java.math.BigDecimal;

public class Rule
extends JSONModel {
    private int ean;
    private int no;
    private String part1;
    private int part2;
    private String constant;
    private int part3;
    private int part4;
    private int verify;
    private int money;
    private BigDecimal bd_money;
    private int weight;
    private BigDecimal bd_weight;
    private int amount;
    private BigDecimal bd_amount;
    private int round;

    public Rule() {
    }

    public static Rule EAN13(int no, String part1, int part2, String constant, int part3, int money, int weight, int amount, int round) {
        return new Rule(no, part1, part2, constant, part3, money, weight, amount, round);
    }

    public static Rule EAN13(int no, String part1, int part2, String constant, int part3, int money, int weight, int amount) {
        return new Rule(no, part1, part2, constant, part3, money, weight, amount, 2);
    }

    public static Rule EAN13(String part1, int part2, String constant, int part3, int money, int weight, int amount) {
        return new Rule(1, part1, part2, constant, part3, money, weight, amount, 2);
    }

    public static Rule EAN18(int no, String part1, int part2, String constant, int part3, int part4, int money, int weight, int amount, int round) {
        return new Rule(no, part1, part2, constant, part3, part4, money, weight, amount, round);
    }

    public static Rule EAN18(int no, String part1, int part2, String constant, int part3, int part4, int money, int weight, int amount) {
        return new Rule(no, part1, part2, constant, part3, part4, money, weight, amount, 2);
    }

    public static Rule EAN18(String part1, int part2, String constant, int part3, int part4, int money, int weight, int amount) {
        return new Rule(1, part1, part2, constant, part3, part4, money, weight, amount, 2);
    }

    public Rule(int no, String part1, int part2, String constant, int part3, int money, int weight, int amount, int round) {
        this(13, no, part1, part2, constant, part3, 0, money, weight, amount, round);
    }

    public Rule(int no, String part1, int part2, String constant, int part3, int part4, int money, int weight, int amount, int round) {
        this(18, no, part1, part2, constant, part3, part4, money, weight, amount, round);
    }

    public Rule(int ean, int no, String part1, int part2, String constant, int part3, int part4, int money, int weight, int amount, int round) {
        this.ean = ean;
        this.no = no;
        this.part1 = part1;
        this.part2 = part2;
        this.constant = constant;
        this.part3 = part3;
        this.part4 = part4;
        this.money = money;
        this.bd_money = BigDecimalUtils.cardinality(money);
        this.weight = weight;
        this.bd_weight = BigDecimalUtils.cardinality(weight);
        this.amount = amount;
        this.bd_amount = BigDecimalUtils.cardinality(amount);
        this.round = round;
    }

    public Integer serialNo() {
        return Integer.parseInt(String.valueOf(this.ean) + String.valueOf(this.no));
    }

    public int getEan() {
        return this.ean;
    }

    public void setEan(int ean) {
        this.ean = ean;
    }

    public int getNo() {
        return this.no;
    }

    public void setNo(int no) {
        this.no = no;
    }

    public String getPart1() {
        return this.part1;
    }

    public void setPart1(String part1) {
        this.part1 = part1;
    }

    public int getPart2() {
        return this.part2;
    }

    public void setPart2(int part2) {
        this.part2 = part2;
    }

    public String getConstant() {
        return this.constant;
    }

    public void setConstant(String constant) {
        this.constant = constant;
    }

    public int getPart3() {
        return this.part3;
    }

    public void setPart3(int part3) {
        this.part3 = part3;
    }

    public int getPart4() {
        return this.part4;
    }

    public void setPart4(int part4) {
        this.part4 = part4;
    }

    public int getMoney() {
        return this.money;
    }

    public void setMoney(int money) {
        this.money = money;
        this.bd_money = BigDecimalUtils.cardinality(money);
    }

    public BigDecimal getBd_money() {
        return this.bd_money;
    }

    public void setBd_money(BigDecimal bd_money) {
        this.bd_money = bd_money;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
        this.bd_weight = BigDecimalUtils.cardinality(weight);
    }

    public BigDecimal getBd_weight() {
        return this.bd_weight;
    }

    public void setBd_weight(BigDecimal bd_weight) {
        this.bd_weight = bd_weight;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
        this.bd_amount = BigDecimalUtils.cardinality(amount);
    }

    public BigDecimal getBd_amount() {
        return this.bd_amount;
    }

    public void setBd_amount(BigDecimal bd_amount) {
        this.bd_amount = bd_amount;
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int round) {
        this.round = round;
    }

    public int getVerify() {
        return this.verify;
    }

    public void setVerify(int verify) {
        this.verify = verify;
    }

    public BigDecimal convertMoney(String money) {
        return new BigDecimal(money).divide(this.bd_money).setScale(this.money, this.round);
    }

    public String convertMoney(BigDecimal money) {
        return String.valueOf(money.multiply(this.bd_money).intValue());
    }

    public BigDecimal convertWeight(String weight) {
        return new BigDecimal(weight).divide(this.bd_weight).setScale(this.weight, this.round);
    }

    public String convertWeight(BigDecimal weight) {
        return String.valueOf(weight.multiply(this.bd_weight).intValue());
    }

    public BigDecimal convertAmount(String amount) {
        return new BigDecimal(amount).multiply(this.bd_amount).setScale(this.amount, this.round);
    }

    public String convertAmount(BigDecimal amount) {
        return String.valueOf(amount.divide(this.bd_amount).intValue());
    }
}

