/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.tool.barcode.loader.rule;

import com.jhscale.common.model.device.UnitType;
import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.tool.barcode.entity.BarCodeInfo;
import com.jhscale.meter.tool.barcode.entity.PLUSpecsItem;
import com.jhscale.meter.tool.barcode.entity.Rule;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;

public abstract class CashierCode
extends JSONModel {
    private Rule rule;

    public abstract int sn();

    public abstract boolean checkLength(String var1);

    public abstract boolean checkPart1(String var1);

    public abstract void parse(String var1, BarCodeInfo var2);

    public abstract void complete(BarCodeInfo var1, int var2, BigDecimal var3);

    protected abstract String paddingPart2(String var1) throws MeterException;

    protected abstract String paddingPart3(String var1) throws MeterException;

    public String addPart2(PLUSpecsItem item) throws MeterException {
        String part2 = null;
        switch (this.getRule().getPart2()) {
            case 1: {
                part2 = String.valueOf(item.getNumber());
                break;
            }
            case 2: {
                part2 = String.valueOf(item.getNo());
                break;
            }
            case 3: {
                part2 = StringUtils.isBlank((CharSequence)this.getRule().getConstant()) ? "" : this.getRule().getConstant();
            }
        }
        return this.paddingPart2(part2);
    }

    public String addPart3(PLUSpecsItem item) throws MeterException {
        String part3 = null;
        switch (this.getRule().getPart3()) {
            case 1: {
                part3 = UnitType.\u8ba1\u4ef6.equals((Object)UnitType.getUnitType((Integer)item.getUnit())) ? this.getRule().convertAmount(item.getVal()) : this.getRule().convertWeight(item.getVal());
                break;
            }
            case 2: {
                part3 = this.getRule().convertMoney(item.getItem());
            }
        }
        return this.paddingPart3(part3);
    }

    public String addPart4(PLUSpecsItem item) throws MeterException {
        return "";
    }

    public String addVerify() {
        return String.valueOf(this.getRule().getVerify());
    }

    protected void parsePart2(BarCodeInfo barCodeInfo, String part2) {
        switch (this.getRule().getPart2()) {
            case 1: {
                barCodeInfo.setNumber(Integer.parseInt(part2));
                break;
            }
            case 2: {
                barCodeInfo.setPluNo(Integer.parseInt(part2));
                break;
            }
            case 3: {
                barCodeInfo.setConstant(part2);
            }
        }
    }

    void parsePart3(BarCodeInfo barCodeInfo, String part) {
        switch (this.getRule().getPart3()) {
            case 1: {
                barCodeInfo.setVal(part);
                break;
            }
            case 2: {
                barCodeInfo.setTotal(this.getRule().convertMoney(part));
            }
        }
    }

    void parsePart4(BarCodeInfo barCodeInfo, String part) {
        switch (this.getRule().getPart4()) {
            case 1: {
                barCodeInfo.setVal(part);
                break;
            }
            case 2: {
                barCodeInfo.setTotal(this.getRule().convertMoney(part));
            }
        }
    }

    protected String padding(String part, int length) throws MeterException {
        int partLength = (part = part == null ? "" : part).length();
        if (partLength > length) {
            throw new MeterException(MeterStateEnum.\u96c6\u4e2d\u6536\u94f6\u5185\u5bb9\u6bb5\u957f\u5ea6\u4e0d\u5408\u6cd5);
        }
        for (int i = 0; i < length - partLength; ++i) {
            part = "0" + part;
        }
        return part;
    }

    public Rule getRule() {
        return this.rule;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }
}

