/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.utils;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.utils.ByteUtils;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class AesHexUtils {
    private static final String AES = "AES";
    private static final String AES_ECB_PADDING = "AES/ECB/NoPadding";

    private AesHexUtils() {
    }

    public static byte[] encrypt(byte[] content, String key) throws MeterException {
        try {
            SecretKeySpec spec = new SecretKeySpec(ByteUtils.fromHexString(key), AES);
            Cipher cipher = Cipher.getInstance(AES_ECB_PADDING);
            cipher.init(1, spec);
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MeterException(MeterStateEnum.AES\u52a0\u5bc6\u5931\u8d25);
        }
    }

    public static byte[] encrypt_byte(String content, String key) throws MeterException {
        return AesHexUtils.encrypt(ByteUtils.fromHexString(content), key);
    }

    public static String encrypt(String content, String key) throws MeterException {
        return ByteUtils.toHexString(AesHexUtils.encrypt(ByteUtils.fromHexString(content), key));
    }

    public static byte[] decrypt(byte[] content, String key) throws MeterException {
        try {
            SecretKeySpec spec = new SecretKeySpec(ByteUtils.fromHexString(key), AES);
            Cipher cipher = Cipher.getInstance(AES_ECB_PADDING);
            cipher.init(2, spec);
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MeterException(MeterStateEnum.AES\u89e3\u5bc6\u5931\u8d25);
        }
    }

    public static String decrypt(String content, String key) throws MeterException {
        return ByteUtils.toHexString(AesHexUtils.decrypt(ByteUtils.fromHexString(content), key));
    }

    public static String decrypt_byte(byte[] content, String key) throws MeterException {
        return ByteUtils.toHexString(AesHexUtils.decrypt(content, key));
    }
}

