/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.utils;

import com.jhscale.meter.model.device.TradeConvert;
import com.jhscale.meter.protocol.model.GlobalPara;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class BigDecimalUtils {
    private static final BigDecimal BASIC = new BigDecimal(10);
    private static Map<String, BigDecimal> unitConvert = new HashMap<String, BigDecimal>();

    private BigDecimalUtils() {
    }

    public static BigDecimal cardinality(int cardinality) {
        BigDecimal val = new BigDecimal(1);
        for (int i = 0; i < cardinality; ++i) {
            val = val.multiply(BASIC);
        }
        return val;
    }

    public static boolean addUnitConvert(String unit, BigDecimal val) {
        BigDecimal bigDecimal = unitConvert.get(unit);
        if (bigDecimal == null) {
            unitConvert.put(unit, val);
            return true;
        }
        return false;
    }

    public static TradeConvert priceItem(BigDecimal weight, String weightUnit, BigDecimal price, String priceUnit, int scale, int round) {
        if (weightUnit.equalsIgnoreCase(priceUnit)) {
            return new TradeConvert(price, weight, price.multiply(weight).setScale(scale, round));
        }
        BigDecimal weightBasic = unitConvert.get(weightUnit);
        BigDecimal priceBasic = unitConvert.get(priceUnit);
        price = price.multiply(weightBasic).divide(priceBasic, 10, 4);
        return new TradeConvert(price.setScale(scale, round), weight, price.multiply(weight).setScale(scale, round));
    }

    public static TradeConvert weightItem(BigDecimal weight, String weightUnit, BigDecimal price, String priceUnit, int scale, int round) {
        if (weightUnit.equalsIgnoreCase(priceUnit)) {
            return new TradeConvert(price, weight, price.multiply(weight).setScale(scale, round));
        }
        BigDecimal weightBasic = unitConvert.get(weightUnit);
        BigDecimal priceBasic = unitConvert.get(priceUnit);
        weight = weight.multiply(weightBasic).divide(priceBasic, 10, 4);
        return new TradeConvert(price, weight.setScale(scale, round), price.multiply(weight).setScale(scale, round));
    }

    public static String bigDecimalToString(BigDecimal val, Integer scale, Integer round, Integer defaultScale, Integer defaultRound) {
        if (Objects.isNull(scale) && Objects.nonNull(defaultScale)) {
            scale = defaultScale;
        }
        if (Objects.isNull(scale)) {
            scale = 2;
        }
        if (Objects.isNull(round) && Objects.nonNull(defaultRound)) {
            round = defaultRound;
        }
        if (Objects.isNull(round)) {
            round = 4;
        }
        return (Objects.nonNull(val) ? val : new BigDecimal(0)).setScale((int)scale, round).toString();
    }

    public static String bigDecimalToString(BigDecimal val, Integer scale) {
        return GlobalPara.getInstance().GetStringTMS(new BigDecimal(BigDecimalUtils.bigDecimalToString(val, scale, null, null, null)));
    }

    public static String bigDecimalToString(BigDecimal val, Integer scale, Integer defaultScale) {
        return GlobalPara.getInstance().GetStringTMS(new BigDecimal(BigDecimalUtils.bigDecimalToString(val, scale, null, defaultScale, null)));
    }

    static {
        unitConvert.put("\u91cd\u91cf", new BigDecimal("1000"));
        unitConvert.put("g", new BigDecimal("1"));
        unitConvert.put("kg", new BigDecimal("1000"));
        unitConvert.put("ton", new BigDecimal("1000000"));
        unitConvert.put("t", new BigDecimal("1000000"));
        unitConvert.put("lb", new BigDecimal("453.59237"));
        unitConvert.put("b", new BigDecimal("453.59237"));
        unitConvert.put("500g", new BigDecimal("500"));
        unitConvert.put("100g", new BigDecimal("100"));
        unitConvert.put("1/4lb", new BigDecimal("113.39809"));
        unitConvert.put("1/4b", new BigDecimal("113.39809"));
    }
}

