/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.utils;

import com.intel.bluetooth.BlueCoveConfigProperties;
import com.intel.bluetooth.BlueCoveImpl;
import com.intel.bluetooth.BlueCoveLocalDeviceProperties;
import com.intel.bluetooth.BluetoothStack;
import com.intel.bluetooth.RemoteDeviceHelper;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.model.device.BlueDevice;
import com.jhscale.meter.utils.BlucatState;
import java.io.IOException;
import java.lang.reflect.Field;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.microedition.io.Connector;
import org.apache.commons.lang3.StringUtils;

public class BluecoveUtils {
    private BluecoveUtils() {
    }

    public static void doctorDevice() throws MeterException {
        if (System.getProperty("os.name").contains("Linux")) {
            JLog.info("{} os device check info [ {} ]", "BTPort", "Is libbluetooth3 and libbluetooth-dev installed?");
            JLog.info("{} os device check info [ {} ]", "BTPort", "run: sudo apt-get install libbluetooth3 libbluetooth-dev");
        }
        if (!LocalDevice.isPowerOn()) {
            throw new MeterException(MeterStateEnum.\u672a\u53d1\u73b0\u84dd\u7259\u9a71\u52a8\u8bbe\u5907);
        }
        JLog.info("{} BluCatUtil info [ {} ]", "BTPort", "BlueCoveState");
        try {
            JLog.debug("{} BluCatUtil ThreadBluetoothStackID\uff1a[ {} ]", "BTPort", BlueCoveImpl.getThreadBluetoothStackID());
            JLog.debug("{} BluCatUtil CurrentThreadBluetoothStackID\uff1a[ {} ]", "BTPort", BlueCoveImpl.getCurrentThreadBluetoothStackID());
            JLog.debug("{} BluCatUtil LocalDevicesID\uff1a[ {} ]", "BTPort", BlueCoveImpl.getLocalDevicesID());
        }
        catch (Exception e) {
            JLog.error("{} BluCatUtil Bluthtooth info error\uff1a[ {} ]", "BTPort", e.getMessage(), e);
            throw new MeterException(MeterStateEnum.\u68c0\u67e5\u84dd\u7259\u4fe1\u606f\u5931\u8d25);
        }
        JLog.info("{} BluCatUtil Bluthtooth info [ {} ]", "BTPort", "BlueCoveConfigProperties");
        String fieldName = null;
        try {
            for (Field f : BlueCoveConfigProperties.class.getDeclaredFields()) {
                if (!f.getName().startsWith("PROPERTY")) continue;
                fieldName = f.getName();
                String PROPERTY = String.valueOf(LocalDevice.getProperty((String)String.valueOf(f.get(null))));
                JLog.debug("{} BluCatUtil PROPERTY:[ {} ]-[ {} ]", "BTPort", fieldName, PROPERTY);
            }
        }
        catch (Exception e) {
            JLog.error("{} BluCatUtil PROPERTY [ {} ] error\uff1a[ {} ]", "BTPort", fieldName, e.getMessage(), e);
            throw new MeterException(MeterStateEnum.\u68c0\u67e5\u84dd\u7259PROPERTY\u4fe1\u606f\u5931\u8d25);
        }
        JLog.info("{} BluCatUtil info [ {} ]", "BTPort", "LocalDeviceProperties");
        try {
            String[] deviceprops = new String[]{"bluetooth.api.version", "bluetooth.master.switch", "bluetooth.sd.attr.retrievable.max", "bluetooth.connected.devices.max", "bluetooth.l2cap.receiveMTU.max", "bluetooth.sd.trans.max", "bluetooth.connected.inquiry.scan", "bluetooth.connected.page.scan", "bluetooth.connected.inquiry", "bluetooth.connected.page"};
            for (String prop : deviceprops) {
                String property = LocalDevice.getProperty((String)prop);
                JLog.debug("{} BluCatUtil deviceprops\uff1a[ {} ]-[ {} ]", "BTPort", prop, property);
            }
            Object[] objectArray = BlueCoveLocalDeviceProperties.class.getDeclaredFields();
            int n = objectArray.length;
            for (int f = 0; f < n; ++f) {
                Object f2 = objectArray[f];
                if (!((Field)f2).getName().startsWith("LOCAL_DEVICE")) continue;
                fieldName = ((Field)f2).getName();
                String LOCAL_DEVICE = String.valueOf(LocalDevice.getProperty((String)String.valueOf(((Field)f2).get(null))));
                JLog.debug("{} BluCatUtil LOCAL_DEVICE:[ {} ]-[ {} ]", "BTPort", fieldName, LOCAL_DEVICE);
            }
        }
        catch (Exception e) {
            JLog.error("{} BluCatUtil LOCAL_DEVICE [ {} ] error\uff1a[ {} ]", "BTPort", fieldName, e.getMessage(), e);
            throw new MeterException(MeterStateEnum.\u68c0\u67e5\u84dd\u7259LOCAL_DEVICE\u4fe1\u606f\u5931\u8d25);
        }
        JLog.info("{} BluCatUtil info [ {} ]", "BTPort", "LocalDeviceFeatures");
        try {
            for (Field f : BluetoothStack.class.getDeclaredFields()) {
                if (!f.getName().startsWith("FEATURE")) continue;
                fieldName = f.getName();
                String FEATURE = String.valueOf(BlueCoveImpl.instance().getLocalDeviceFeature(f.getInt(null)));
                JLog.debug("{} BluCatUtil FEATURE:[ {} ]-[ {} ]", "BTPort", fieldName, FEATURE);
            }
        }
        catch (Exception e) {
            JLog.error("{} BluCatUtil FEATURE [ {} ] error\uff1a[ {} ]", "BTPort", fieldName, e.getMessage(), e);
            throw new MeterException(MeterStateEnum.\u68c0\u67e5\u84dd\u7259FEATURE\u4fe1\u606f\u5931\u8d25);
        }
        JLog.info("{} BluCatUtil device Success.", "BTPort");
    }

    public static String deviceName(RemoteDevice device) {
        String name = null;
        int count = 0;
        do {
            try {
                name = device.getFriendlyName(false);
            }
            catch (IOException e) {
                JLog.error("{} deviceName \u5730\u5740:{} \u83b7\u53d6\u540d\u79f0\u5f02\u5e38\uff1a{}", "BTPort", device.getBluetoothAddress(), e.getMessage(), e);
            }
        } while (StringUtils.isBlank((CharSequence)name) && ++count < 3);
        return BluecoveUtils.clean(name);
    }

    public static BlueDevice deviceInfo(RemoteDevice device) {
        String address = device.getBluetoothAddress();
        String name = BluecoveUtils.deviceName(device);
        BlueDevice<RemoteDevice> blueDevice = new BlueDevice<RemoteDevice>(address, device, name, device.isTrustedDevice(), device.isEncrypted());
        String rssi = "NA";
        String toret = "";
        toret = toret + BluecoveUtils.clean(address) + ", \"" + BluecoveUtils.clean(name) + "\", Trusted:" + device.isTrustedDevice() + ", Encrypted:" + device.isEncrypted();
        if (BlucatState.rssi) {
            try {
                rssi = String.valueOf(RemoteDeviceHelper.readRSSI((RemoteDevice)device));
            }
            catch (Throwable e) {
                String url = "btl2cap://" + device.getBluetoothAddress() + ":1";
                try {
                    BlucatState.connection = Connector.open((String)url, (int)3, (boolean)true);
                    rssi = String.valueOf(RemoteDeviceHelper.readRSSI((RemoteDevice)device));
                    BlucatState.connection.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            toret = toret + ", " + rssi;
        }
        blueDevice.setRemark(toret);
        return blueDevice;
    }

    public static String clean(String str) {
        return StringUtils.isNotBlank((CharSequence)str) ? str.replace("\"", "''").replace("\n", " ") : str;
    }
}

