/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.utils;

import com.jhscale.common.utils.BigDecimalUtils;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class ByteUtils {
    private static final short UNSIGNED_MAX_VALUE = 255;
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String hex2Ascii(String hexStr) {
        StringBuilder output = new StringBuilder("");
        for (int i = 0; i < hexStr.length(); i += 2) {
            String str = hexStr.substring(i, i + 2);
            output.append((char)Integer.parseInt(str, 16));
        }
        return output.toString();
    }

    public static String ascii2Hex(String asciiStr) {
        char[] chars = asciiStr.toCharArray();
        StringBuilder hex = new StringBuilder();
        for (char ch : chars) {
            hex.append(Integer.toHexString(ch));
        }
        return hex.toString().toUpperCase();
    }

    public static String formatMark(String mark) {
        String binaryStr = Integer.toBinaryString(Integer.parseInt(mark, 16));
        int lg = binaryStr.length();
        if (lg < 8) {
            int cn = 8 - lg;
            String str = "";
            for (int i = 0; i < cn; ++i) {
                str = str + "0";
            }
            return str + binaryStr;
        }
        return binaryStr;
    }

    public static String ten2two(int val, int length) {
        String binaryStr = Integer.toBinaryString(val);
        int lg = binaryStr.length();
        if (lg < length) {
            int cn = length - lg;
            String str = "";
            for (int i = 0; i < cn; ++i) {
                str = str + "0";
            }
            return str + binaryStr;
        }
        return binaryStr;
    }

    public static String inserE(String targe, int index, String str) {
        String res = "";
        for (int i = targe.length(); i > 0; --i) {
            if (targe.length() - i == index) {
                res = str + res;
            }
            res = targe.charAt(i - 1) + res;
        }
        return res;
    }

    public static String formatData(String mark) {
        String binaryStr = Integer.toBinaryString(Integer.parseInt(mark, 16));
        int lg = binaryStr.length();
        if (lg < 8) {
            int cn = 8 - lg;
            String str = "";
            for (int i = 0; i < cn; ++i) {
                str = str + "0";
            }
            binaryStr = str + binaryStr;
        }
        return new StringBuffer(binaryStr).reverse().toString();
    }

    public static byte[] fromHexAscii(String s) throws NumberFormatException {
        try {
            int len = s.length();
            if (len % 2 != 0) {
                throw new NumberFormatException("Hex ascii must be exactly two digits per byte.");
            }
            int out_len = len / 2;
            byte[] out = new byte[out_len];
            int i = 0;
            StringReader sr = new StringReader(s);
            while (i < out_len) {
                int val = 16 * ByteUtils.fromHexDigit(sr.read()) + ByteUtils.fromHexDigit(sr.read());
                out[i++] = (byte)val;
            }
            return out;
        }
        catch (IOException e) {
            throw new InternalError("IOException reading from StringReader?!?!");
        }
    }

    public static String toBinary(int length) {
        String str = Integer.toBinaryString(length);
        if (str.length() < 2) {
            str = length == 0 ? "01" : "0" + str;
        }
        return str;
    }

    private static int fromHexDigit(int c) throws NumberFormatException {
        if (c >= 48 && c < 58) {
            return c - 48;
        }
        if (c >= 65 && c < 71) {
            return c - 55;
        }
        if (c >= 97 && c < 103) {
            return c - 87;
        }
        throw new NumberFormatException(39 + c + "' is not a valid hexadecimal digit.");
    }

    public static String covert102Hex(String data) {
        Integer dInt = Integer.parseInt(data);
        String hexString = Integer.toHexString(dInt);
        if (hexString.length() % 2 != 0) {
            hexString = "0" + hexString;
        }
        return ByteUtils.convert(hexString);
    }

    public static String convert(String hex) {
        return ByteUtils.toHexAscii(ByteUtils.reverse(ByteUtils.fromHexAscii(hex)));
    }

    public static int hex2Ten(String hex) {
        return Integer.parseInt(ByteUtils.convert(hex), 16);
    }

    public static String hex2Bin(String hex, int bit_len) {
        String binaryStr = Integer.toBinaryString(ByteUtils.hex2Ten(hex));
        int lg = binaryStr.length();
        if (lg < (bit_len *= 8)) {
            int cn = bit_len - lg;
            String str = "";
            for (int i = 0; i < cn; ++i) {
                str = str + "0";
            }
            return str + binaryStr;
        }
        return binaryStr;
    }

    public static String ten2Hex(int i) {
        return ByteUtils.convert(ByteUtils.appendFill(Integer.toHexString(i), 8));
    }

    public static String ten2Hex(int i, int length) {
        return ByteUtils.convert(ByteUtils.appendFill(Integer.toHexString(i).toUpperCase(), length));
    }

    public static String toHexAscii(byte[] bytes) {
        int len = bytes.length;
        StringWriter sw = new StringWriter(len * 2);
        for (int i = 0; i < len; ++i) {
            ByteUtils.addHexAscii(bytes[i], sw);
        }
        return sw.toString();
    }

    public static String toHexAscii(byte b) {
        StringWriter sw = new StringWriter(2);
        ByteUtils.addHexAscii(b, sw);
        return sw.toString();
    }

    private static void addHexAscii(byte b, StringWriter sw) {
        short ub = ByteUtils.toUnsigned(b);
        int h1 = ub / 16;
        int h2 = ub % 16;
        sw.write(ByteUtils.toHexDigit(h1));
        sw.write(ByteUtils.toHexDigit(h2));
    }

    private static short toUnsigned(byte b) {
        return (short)(b < 0 ? 256 + b : b);
    }

    private static char toHexDigit(int h) {
        char out = h <= 9 ? (char)(h + 48) : (char)(h + 55);
        return out;
    }

    public static byte[] reverse(byte[] bytes) {
        int len = bytes.length;
        byte[] newBytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            newBytes[i] = bytes[len - 1 - i];
        }
        return newBytes;
    }

    public static int[] reverse(int[] ints) {
        int len = ints.length;
        int[] newInts = new int[len];
        for (int i = 0; i < len; ++i) {
            newInts[i] = ints[len - 1 - i];
        }
        return newInts;
    }

    public static String int2HexWithPush(int val, int length) {
        String hex = Integer.toHexString(val);
        int hexLength = hex.length();
        if (hexLength < length) {
            for (int i = 0; i < length - hexLength; ++i) {
                hex = "0" + hex;
            }
        } else {
            hex = hex.substring(0, length);
        }
        hex = ByteUtils.convert(hex);
        return hex;
    }

    public static String int2Hex(int val) {
        String hex = Integer.toHexString(val);
        if (hex.length() % 2 != 0) {
            hex = "0" + hex;
        }
        hex = ByteUtils.convert(hex);
        return hex;
    }

    public static String dataFormat(String data) {
        String hexString = Integer.toHexString(Integer.parseInt(data, 2));
        if (hexString.length() % 2 != 0) {
            hexString = "0" + hexString;
        }
        return hexString;
    }

    public static String string2HexUTF8(String strPart) {
        return ByteUtils.string2HexString(strPart, "UTF-8");
    }

    public static String string2HexString(String strPart, String tochartype) {
        try {
            return ByteUtils.bytes2HexString(strPart.getBytes(tochartype));
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String bytes2HexString(byte[] b) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            result.append(String.format("%02X", b[i]));
        }
        return result.toString();
    }

    public static String toHexString(byte[] var0) {
        String var1 = "";
        for (int var2 = 0; var2 < var0.length; ++var2) {
            var1 = var1 + HEX_CHARS[var0[var2] >>> 4 & 0xF];
            var1 = var1 + HEX_CHARS[var0[var2] & 0xF];
        }
        return var1.toUpperCase();
    }

    public static int indexOf(String content, String str) {
        int index = -1;
        char[] chars = content.toCharArray();
        for (int i = 0; i < content.length() / 2; ++i) {
            String st = String.valueOf(chars[i * 2]) + String.valueOf(chars[i * 2 + 1]);
            if (!st.equals(str)) continue;
            index = i * 2;
            break;
        }
        return index;
    }

    public static Date convertTime(String hexString) {
        long time = Long.parseLong(ByteUtils.convert(hexString), 16);
        return new Date((time + 946656000L) * 1000L);
    }

    public static String convertTime(Date date) {
        long time = (date.getTime() - 946656000L) / 1000L;
        return ByteUtils.convert(ByteUtils.appendFill(Long.toHexString(time), 8));
    }

    public static BigDecimal convertBigDecimal(String hexString) {
        String convert = ByteUtils.convert(hexString);
        int money = Integer.parseUnsignedInt(convert, 16);
        return BigDecimal.valueOf(money >> 3, money & 7);
    }

    public static int toSPF(BigDecimal d) {
        long A2 = d.multiply(new BigDecimal(10000000)).add(BigDecimal.valueOf(BigDecimalUtils.compareLessZeroValue((BigDecimal)d) ? -0.5 : 0.5)).longValue();
        int B2 = 7;
        while (true) {
            if (B2 == 0) {
                if (A2 >= 0x10000000L) {
                    A2 = 0xFFFFFFFL;
                    break;
                }
                if (A2 >= -268435456L) break;
                A2 = -268435456L;
                break;
            }
            if (A2 >= 0x10000000L || A2 < -268435456L) {
                A2 = A2 > 0L ? (A2 + 5L) / 10L : (A2 - 5L) / 10L;
                --B2;
                continue;
            }
            if ((long)((int)(A2 / 10L) * 10) != A2) break;
            A2 /= 10L;
            --B2;
        }
        return (int)(A2 << 3 | (long)B2);
    }

    public static int toSPF2(BigDecimal d) {
        int flot = BigDecimalUtils.getNumberOfDecimalPlace((BigDecimal)d);
        int fv = 1;
        for (int i = 0; i < flot; ++i) {
            fv *= 10;
        }
        long A2 = d.multiply(BigDecimal.valueOf(fv)).add(BigDecimal.valueOf(BigDecimalUtils.compareLessZeroValue((BigDecimal)d) ? -0.5 : 0.5)).longValue();
        int B2 = flot;
        return (int)(A2 << 3 | (long)B2);
    }

    public static byte[] fromHexString(String var0) {
        char[] var1 = var0.toUpperCase().toCharArray();
        int var2 = 0;
        for (int var3 = 0; var3 < var1.length; ++var3) {
            if ((var1[var3] < '0' || var1[var3] > '9') && (var1[var3] < 'A' || var1[var3] > 'F')) continue;
            ++var2;
        }
        byte[] var6 = new byte[var2 + 1 >> 1];
        int var4 = var2 & 1;
        for (int var5 = 0; var5 < var1.length; ++var5) {
            if (var1[var5] >= '0' && var1[var5] <= '9') {
                var6[var4 >> 1] = (byte)(var6[var4 >> 1] << 4);
                var6[var4 >> 1] = (byte)(var6[var4 >> 1] | var1[var5] - 48);
            } else {
                if (var1[var5] < 'A' || var1[var5] > 'F') continue;
                var6[var4 >> 1] = (byte)(var6[var4 >> 1] << 4);
                var6[var4 >> 1] = (byte)(var6[var4 >> 1] | var1[var5] - 65 + 10);
            }
            ++var4;
        }
        return var6;
    }

    public static byte[] byteMerger(byte[] byte_1, byte[] byte_2) {
        byte[] byte_3 = new byte[byte_1.length + byte_2.length];
        System.arraycopy(byte_1, 0, byte_3, 0, byte_1.length);
        System.arraycopy(byte_2, 0, byte_3, byte_1.length, byte_2.length);
        return byte_3;
    }

    public static int[] byteMerger(int[] int_1, int[] int_2) {
        int[] int_3 = new int[int_1.length + int_2.length];
        System.arraycopy(int_1, 0, int_3, 0, int_1.length);
        System.arraycopy(int_2, 0, int_3, int_1.length, int_2.length);
        return int_3;
    }

    public static String convertHex(String hex) {
        return ByteUtils.toHexAscii(ByteUtils.reverse(ByteUtils.fromHexString(hex)));
    }

    public static String completeBytes(Integer num, int length) {
        String hexNum = Integer.toHexString(num);
        return ByteUtils.completeBytes(hexNum, length * 2).toUpperCase();
    }

    public static String completeBytes(String content, int length) {
        int contenLength;
        if (content.length() % 2 != 0) {
            content = "0" + content;
        }
        if (length < (contenLength = (content = ByteUtils.toHexString(ByteUtils.reverse(ByteUtils.fromHexString(content)))).length())) {
            return content.substring(0, length);
        }
        for (int i = 0; i < length - contenLength; ++i) {
            content = content + "0";
        }
        return content;
    }

    public static final LocalDateTime getStartTime() {
        return LocalDateTime.of(2000, 1, 1, 0, 0, 0, 0);
    }

    public static String appendFill(String content) {
        String res = content;
        int lg = content.length() / 2;
        if (lg % 16 == 0) {
            return content;
        }
        int appendBit = 16 - lg % 16;
        if (appendBit != 0) {
            for (int i = 0; i < appendBit; ++i) {
                res = i == 0 ? res + "F0" : res + "00";
            }
        }
        return res;
    }

    public static String appendFill(String hexString, int length) {
        if (StringUtils.isBlank((CharSequence)hexString)) {
            return "";
        }
        if (hexString.length() >= length) {
            return hexString.substring(0, length);
        }
        int pantting = length - hexString.length();
        for (int i = 0; i < pantting; ++i) {
            hexString = "0" + hexString;
        }
        return hexString;
    }

    public static byte[] intToBytes(int a, int length) {
        byte[] bs = new byte[length];
        for (int i = bs.length - 1; i >= 0; --i) {
            bs[i] = (byte)(a % 255);
            a /= 255;
        }
        return bs;
    }

    public static byte[] intToBytes(int a) {
        return ByteUtils.intToBytes(a, 1);
    }

    public static int bytesToInt(byte[] bs) {
        int a = 0;
        for (int i = bs.length - 1; i >= 0; --i) {
            a = (int)((double)a + (double)bs[i] * Math.pow(255.0, bs.length - i - 1));
        }
        return a;
    }
}

