/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.utils;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import org.apache.commons.lang3.StringUtils;

public class CodeUtils {
    public static final int[] codeArr = new int[]{16, 15, 156, 139, 94, 46, 77, 125, 248, 232, 108, 217, 201, 63, 186, 170, 48, 138, 14, 157, 76, 95, 107, 231, 45, 249, 200, 126, 218, 169, 17, 187, 188, 137, 80, 44, 75, 158, 230, 106, 199, 49, 250, 18, 168, 219, 13, 127, 112, 189, 74, 81, 105, 229, 12, 198, 159, 19, 167, 251, 50, 43, 220, 136, 144, 20, 190, 113, 228, 104, 197, 42, 82, 166, 11, 51, 252, 135, 73, 221, 222, 103, 145, 227, 52, 191, 196, 114, 41, 165, 10, 83, 134, 253, 72, 21, 176, 223, 226, 22, 53, 195, 146, 71, 164, 115, 9, 133, 84, 40, 254, 102, 208, 225, 8, 177, 194, 70, 39, 163, 147, 54, 132, 116, 23, 101, 85, 255, 240, 224, 86, 209, 193, 69, 178, 162, 38, 131, 148, 24, 100, 117, 7, 55, 239, 241, 192, 56, 210, 161, 87, 179, 130, 6, 99, 149, 25, 37, 118, 68, 160, 26, 242, 129, 211, 207, 57, 180, 98, 88, 36, 150, 67, 5, 119, 238, 128, 120, 206, 243, 35, 212, 97, 175, 181, 4, 66, 89, 151, 58, 237, 27, 96, 205, 121, 28, 244, 174, 213, 65, 3, 182, 34, 143, 90, 236, 152, 59, 204, 64, 111, 173, 122, 245, 60, 214, 2, 142, 183, 33, 235, 29, 91, 153, 154, 172, 110, 92, 79, 123, 246, 141, 215, 32, 184, 234, 61, 30, 203, 1, 171, 47, 155, 93, 0, 140, 62, 247, 124, 216, 233, 31, 185, 202, 78, 109};
    public static final int[] decodeArr = new int[]{244, 239, 216, 200, 185, 173, 153, 142, 114, 106, 90, 74, 54, 46, 18, 1, 0, 30, 43, 57, 65, 95, 99, 124, 139, 156, 161, 191, 195, 221, 237, 251, 233, 219, 202, 180, 170, 157, 136, 118, 109, 88, 71, 61, 35, 24, 5, 241, 16, 41, 60, 75, 84, 100, 121, 143, 147, 166, 189, 207, 214, 236, 246, 13, 209, 199, 186, 172, 159, 133, 117, 103, 94, 78, 50, 36, 20, 6, 254, 228, 34, 51, 72, 91, 108, 126, 130, 150, 169, 187, 204, 222, 227, 243, 4, 21, 192, 182, 168, 154, 140, 125, 111, 81, 69, 52, 39, 22, 10, 255, 226, 210, 48, 67, 87, 105, 123, 141, 158, 174, 177, 194, 212, 229, 248, 7, 27, 47, 176, 163, 152, 137, 122, 107, 92, 77, 63, 33, 17, 3, 245, 231, 217, 203, 64, 82, 102, 120, 138, 155, 171, 188, 206, 223, 224, 242, 2, 19, 37, 56, 160, 149, 135, 119, 104, 89, 73, 58, 44, 29, 15, 240, 225, 211, 197, 183, 96, 115, 134, 151, 167, 184, 201, 218, 234, 252, 14, 31, 32, 49, 66, 85, 146, 132, 116, 101, 86, 70, 55, 40, 26, 12, 253, 238, 208, 193, 178, 165, 112, 131, 148, 164, 181, 198, 215, 232, 249, 11, 28, 45, 62, 79, 80, 97, 129, 113, 98, 83, 68, 53, 38, 23, 9, 250, 235, 220, 205, 190, 175, 144, 128, 145, 162, 179, 196, 213, 230, 247, 8, 25, 42, 59, 76, 93, 110, 127};

    private static String code(String str, int[] arr) throws MeterException {
        if (StringUtils.isBlank((CharSequence)str) || str.length() % 2 != 0) {
            throw new MeterException(MeterStateEnum.AD\u6570\u636e\u5305\u683c\u5f0f\u9519\u8bef);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < str.length() / 2; ++i) {
            int index = Integer.parseInt(str.substring(i * 2, i * 2 + 2), 16);
            String val = Integer.toHexString(arr[index]);
            if (val.length() != 2) {
                val = "0" + val;
            }
            stringBuffer.append(val);
        }
        return stringBuffer.toString().toUpperCase();
    }

    private static byte[] code(byte[] source, int[] arr) throws MeterException {
        if (source == null || source.length == 0) {
            throw new MeterException(MeterStateEnum.AD\u6570\u636e\u5305\u683c\u5f0f\u9519\u8bef);
        }
        byte[] target = new byte[source.length];
        for (int i = 0; i < source.length; ++i) {
            target[i] = (byte)arr[source[i] & 0xFF];
        }
        return target;
    }

    public static byte[] encode(byte[] bytes) throws MeterException {
        return CodeUtils.code(bytes, codeArr);
    }

    public static String encode(String data) throws MeterException {
        return CodeUtils.code(data, codeArr);
    }

    public static byte[] decode(byte[] bytes) throws MeterException {
        return CodeUtils.code(bytes, decodeArr);
    }

    public static String decode(String data) throws MeterException {
        return CodeUtils.code(data, decodeArr);
    }

    public static String checkData(String data) throws MeterException {
        String start = data.substring(0, 2);
        if (!"02".equals(start)) {
            throw new MeterException(MeterStateEnum.AD\u6570\u636e\u5305\u5934\u65e0\u6548);
        }
        String end = data.substring(data.length() - 2, data.length());
        if (!"03".equals(end)) {
            throw new MeterException(MeterStateEnum.AD\u6570\u636e\u5305\u5c3e\u65e0\u6548);
        }
        return data.substring(2, data.length() - 2);
    }
}

