/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.utils;

import com.jhscale.common.utils.JSONUtils;
import com.jhscale.meter.utils.ByteUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class FileUtils {
    private static final byte STX = 85;
    private static final byte ETX = 4;
    private static final byte DLE = 5;

    private FileUtils() {
    }

    public static String fileToHex(File file) {
        try {
            return FileUtils.inputStreamToHex(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String fileContentsToHex(String content) {
        byte[] bytes = content.getBytes();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            builder.append(Integer.toHexString(bytes[i] - 64));
        }
        return builder.toString();
    }

    public static String hexToFileContents(String hex) {
        byte[] bytes = new byte[hex.length()];
        for (int i = 0; i < hex.length(); ++i) {
            bytes[i] = (byte)(Integer.parseInt(String.valueOf(hex.charAt(i)), 16) + 64);
        }
        return new String(bytes);
    }

    public static String inputStreamToHex(InputStream inputStream) {
        return ByteUtils.toHexAscii(FileUtils.inputStreamToBytes(inputStream)).toUpperCase();
    }

    public static byte[] fileToBytes(File file) {
        try {
            return FileUtils.inputStreamToBytes(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] inputStreamToBytes(InputStream inputStream) {
        ByteArrayOutputStream bos = null;
        try {
            bos = new ByteArrayOutputStream();
            int len = 0;
            byte[] buffer = new byte[1024];
            while (-1 != (len = inputStream.read(buffer))) {
                bos.write(buffer, 0, len);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static byte[] upgradeBytes(byte[] source) {
        if (source == null || source.length == 0) {
            return new byte[0];
        }
        ArrayList<Byte> targetList = new ArrayList<Byte>();
        targetList.add((byte)5);
        for (byte b : source) {
            if (b == 85 || b == 4 || b == 5) {
                targetList.add((byte)5);
            }
            targetList.add(b);
        }
        targetList.add((byte)85);
        byte[] target = new byte[targetList.size()];
        for (int i = 0; i < targetList.size(); ++i) {
            target[i] = (Byte)targetList.get(i);
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writer(String str, String filePath) {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(filePath));
            out.write(str);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String reader(File file) {
        if (file == null || !file.exists() || file.isDirectory()) {
            return null;
        }
        FileReader fr = null;
        BufferedReader br = null;
        try {
            fr = new FileReader(file);
            br = new BufferedReader(fr);
            StringBuffer buffer = new StringBuffer();
            while (br.ready()) {
                buffer = buffer.append(br.readLine());
            }
            String string = buffer.toString();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static <T> T reader(File file, Class<T> clazz) {
        return (T)JSONUtils.jsonToObject((String)FileUtils.reader(file), clazz);
    }

    public static <T> List<T> readerList(File file, Class<T> clazz) {
        return JSONUtils.jsonToList((String)FileUtils.reader(file), clazz);
    }
}

