/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.utils;

import com.jhscale.meter.mqtt.em.SensorLock;
import com.jhscale.meter.mqtt.entity.SensorLocking;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class MQTTUtils {
    private MQTTUtils() {
    }

    public static String int2Hex(int i) {
        String hex = Integer.toHexString(i);
        return hex.length() % 2 != 0 ? "0" + hex : hex;
    }

    public static String int2Hex2(int i) {
        String hex = Integer.toHexString(i);
        int insert = 4 - hex.length();
        for (int j = 0; j < insert; ++j) {
            hex = "0" + hex;
        }
        return hex;
    }

    public static int hex2Int(String hex) {
        return Integer.parseInt(hex, 16);
    }

    public static String hex2Bit(String hex) {
        String bit = Integer.toBinaryString(Integer.parseInt(hex, 16));
        int insert = 8 - bit.length();
        for (int i = 0; i < insert; ++i) {
            bit = "0" + bit;
        }
        return bit;
    }

    public static String bit2Hex(String bit) {
        String hex = Integer.toHexString(Integer.parseInt(bit, 2));
        return hex.length() % 2 != 0 ? "0" + hex : hex;
    }

    public static int bit2Int(String bit) {
        return Integer.parseInt(bit, 2);
    }

    public static String int2Bit(int i) {
        return MQTTUtils.int2Bit(i, 2);
    }

    public static String int2Bit(int i, int len) {
        String bitStr = Integer.toBinaryString(i);
        int insert = len - bitStr.length();
        for (int index = 0; index < insert; ++index) {
            bitStr = "0" + bitStr;
        }
        return bitStr;
    }

    public static void bitPart(List<Character> chars, List<String> params, int i) {
        try {
            if (StringUtils.isNotBlank((CharSequence)params.get(i))) {
                chars.add(Character.valueOf('1'));
            } else {
                chars.add(Character.valueOf('0'));
            }
        }
        catch (Exception e) {
            chars.add(Character.valueOf('0'));
        }
    }

    public static void collect(List<Character> chars2, List<Character> chars) {
        if (chars.contains(Character.valueOf('1'))) {
            chars2.add(Character.valueOf('1'));
        } else {
            chars2.add(Character.valueOf('0'));
        }
    }

    public static String floatArr2Hex(List<Character> list) {
        StringBuffer sb = new StringBuffer();
        if (list != null && !list.isEmpty()) {
            for (int i = list.size(); i > 0; --i) {
                sb.insert(0, list.get(i - 1));
            }
        }
        return sb.toString();
    }

    public static String sensorLock(List<SensorLocking> sensorLockings) {
        int[] lock = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        int[] hardware = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        int[] link = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        int[] config = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        int[] ovf = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        Optional.ofNullable(sensorLockings).orElse(Collections.emptyList()).forEach(sensorLocking -> {
            switch (sensorLocking.getLock()) {
                case LOCK: {
                    lock[sensorLocking.getIndex().intValue()] = 1;
                    break;
                }
                case HARDWARE: {
                    hardware[sensorLocking.getIndex().intValue()] = 1;
                    break;
                }
                case LINK: {
                    link[sensorLocking.getIndex().intValue()] = 1;
                    break;
                }
                case CONFIG: {
                    config[sensorLocking.getIndex().intValue()] = 1;
                    break;
                }
                case OVF: {
                    ovf[sensorLocking.getIndex().intValue()] = 1;
                }
            }
        });
        return MQTTUtils.intBinArrToHex(lock) + MQTTUtils.intBinArrToHex(hardware) + MQTTUtils.intBinArrToHex(link) + MQTTUtils.intBinArrToHex(config) + MQTTUtils.intBinArrToHex(ovf);
    }

    public static String intBinArrToHex(int[] binArr) {
        String bin = "";
        for (int i : binArr) {
            bin = bin + i;
        }
        return MQTTUtils.int2Hex2(MQTTUtils.bit2Int(bin));
    }

    public static List<SensorLocking> sensorLock(String sesorLockHex) {
        int i;
        int[] lock = MQTTUtils.hexToIntBinArr(sesorLockHex.substring(0, 4));
        int[] hardware = MQTTUtils.hexToIntBinArr(sesorLockHex.substring(4, 8));
        int[] link = MQTTUtils.hexToIntBinArr(sesorLockHex.substring(8, 12));
        int[] config = MQTTUtils.hexToIntBinArr(sesorLockHex.substring(12, 16));
        int[] ovf = MQTTUtils.hexToIntBinArr(sesorLockHex.substring(16, 20));
        ArrayList<SensorLocking> sensorLockings = new ArrayList<SensorLocking>();
        if (MQTTUtils.contains(lock, 1)) {
            for (i = 0; i < lock.length; ++i) {
                if (lock[i] != 1) continue;
                sensorLockings.add(new SensorLocking(i, SensorLock.LOCK));
            }
        }
        if (MQTTUtils.contains(hardware, 1)) {
            for (i = 0; i < hardware.length; ++i) {
                if (hardware[i] != 1) continue;
                sensorLockings.add(new SensorLocking(i, SensorLock.HARDWARE));
            }
        }
        if (MQTTUtils.contains(link, 1)) {
            for (i = 0; i < link.length; ++i) {
                if (link[i] != 1) continue;
                sensorLockings.add(new SensorLocking(i, SensorLock.LINK));
            }
        }
        if (MQTTUtils.contains(config, 1)) {
            for (i = 0; i < config.length; ++i) {
                if (config[i] != 1) continue;
                sensorLockings.add(new SensorLocking(i, SensorLock.CONFIG));
            }
        }
        if (MQTTUtils.contains(ovf, 1)) {
            for (i = 0; i < ovf.length; ++i) {
                if (ovf[i] != 1) continue;
                sensorLockings.add(new SensorLocking(i, SensorLock.OVF));
            }
        }
        return sensorLockings;
    }

    public static int[] hexToIntBinArr(String hex) {
        String bin = MQTTUtils.int2Bit(MQTTUtils.hex2Int(hex), 16);
        int[] binArr = new int[bin.length()];
        for (int i = 0; i < bin.length(); ++i) {
            binArr[i] = Integer.parseInt(String.valueOf(bin.charAt(i)));
        }
        return binArr;
    }

    private static boolean contains(int[] arr, int val) {
        if (arr == null || arr.length == 0) {
            return false;
        }
        for (int i : arr) {
            if (i != val) continue;
            return true;
        }
        return false;
    }
}

