/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.utils;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MapUtils {
    public static Map<String, String> toMap(Object obj) {
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<Field> fields = new ArrayList<Field>();
        MapUtils.getAllFieldList(obj.getClass(), fields);
        if (!fields.isEmpty()) {
            fields.forEach(field -> {
                try {
                    field.setAccessible(true);
                    Object o = field.get(obj);
                    if (o != null) {
                        if (o instanceof String || o instanceof Integer || o instanceof Double || o instanceof Long || o instanceof BigDecimal) {
                            map.put(field.getName(), o.toString());
                        } else {
                            map.put(field.getName(), JSON.toJSONString((Object)o));
                        }
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            });
        }
        return map;
    }

    public static void getAllFieldList(Class clazz, List<Field> fields) {
        Class superclass;
        Field[] declaredFields = clazz.getDeclaredFields();
        if (declaredFields != null && declaredFields.length > 0) {
            fields.addAll(Arrays.asList(declaredFields));
        }
        if (Objects.nonNull(superclass = clazz.getSuperclass())) {
            MapUtils.getAllFieldList(superclass, fields);
        }
    }
}

