/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.utils;

import com.jhscale.common.model.device._inner.PublicExecute;
import com.jhscale.common.model.device._inner.PublicExecuteModify;
import com.jhscale.common.model.device._inner.PublicExecuteRecovery;
import com.jhscale.common.utils.ByteUtils;
import com.jhscale.common.utils.DDataUtils;
import com.jhscale.common.utils.GJSONUtils;
import com.jhscale.meter.entity.ProtocolAnalyse;
import com.jhscale.meter.protocol.model.GlobalPara;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class MeterUtils {
    private MeterUtils() {
    }

    public static int checkIsDoublePointTwo(BigDecimal val) {
        if (val == null) {
            return 0;
        }
        String[] ss = val.toString().split("\\.");
        return ss.length <= 1 ? 0 : ss[1].length();
    }

    public static int floatVal(int floa) {
        int floaVal = 1;
        for (int i = 0; i < floa; ++i) {
            floaVal *= 10;
        }
        return floaVal;
    }

    public static String public_response_package(List<PublicExecute> accepts, List<PublicExecute> sends) {
        if ((sends == null || sends.isEmpty()) && accepts != null && !accepts.isEmpty()) {
            for (PublicExecute callExecute : accepts) {
                if (!(callExecute instanceof PublicExecuteRecovery)) continue;
                if (sends == null) {
                    sends = new ArrayList<PublicExecute>();
                }
                sends.add((PublicExecute)new PublicExecuteModify(callExecute.getType()));
            }
        }
        if (GlobalPara.getInstance().isRunLog()) {
            System.out.println(String.format("Request --- Package: %s", GJSONUtils.objectToJSON(accepts)));
            System.out.println(String.format("Response --- Package: %s", GJSONUtils.objectToJSON(sends)));
        }
        return MeterUtils.answers_execute(sends);
    }

    public static String public_response_package(PublicExecute accept, List<PublicExecute> answers) {
        if (accept instanceof PublicExecuteRecovery && (answers == null || answers.isEmpty())) {
            answers = new ArrayList<PublicExecute>();
            answers.add((PublicExecute)new PublicExecuteModify(accept.getType()));
        }
        if (GlobalPara.getInstance().isRunLog()) {
            System.out.println(String.format("Accept --- Package: %s", GJSONUtils.objectToJSON((Object)accept)));
            System.out.println(String.format("Answers --- Package: %s", GJSONUtils.objectToJSON(answers)));
        }
        return MeterUtils.answers_execute(answers);
    }

    private static String answers_execute(List<PublicExecute> answers) {
        if (answers != null && !answers.isEmpty()) {
            String response = DDataUtils.Public_Package_No_Reflex(answers);
            if (GlobalPara.getInstance().isRunLog()) {
                System.out.println(String.format("Response --- Content\uff1a%s", response));
            }
            return response;
        }
        return "";
    }

    public static ProtocolAnalyse analyse(byte[] buffer) {
        int i;
        ProtocolAnalyse analyse = new ProtocolAnalyse();
        if (buffer[0] != 2) {
            boolean has_prefix = false;
            for (i = 0; i < buffer.length; ++i) {
                if (buffer[i] != 2) continue;
                buffer = Arrays.copyOfRange(buffer, i, buffer.length);
                has_prefix = true;
                break;
            }
            if (!has_prefix) {
                return analyse;
            }
        }
        int index = 0;
        for (i = 0; i < buffer.length; ++i) {
            byte[] copy;
            int length;
            if (buffer[i] != 3 || (length = Integer.parseInt(ByteUtils.toHexString((byte[])Arrays.copyOfRange(copy = Arrays.copyOfRange(buffer, index, i + 1), 1, 2)), 16) + 5) != copy.length) continue;
            analyse.addBytes(copy);
            index = i + 1;
        }
        analyse.setSurplus(Arrays.copyOfRange(buffer, index, buffer.length));
        return analyse;
    }

    public static String append(int val) {
        return ByteUtils.int2HexWithPush_nr((int)val, (int)2);
    }

    public static String append(int val, int length) {
        return ByteUtils.int2HexWithPush_nr((int)val, (int)length);
    }

    public static String append(String text) {
        return (StringUtils.isNotBlank((CharSequence)text) ? ByteUtils.toHexString((byte[])text.getBytes()) : "") + "00";
    }

    public static String append(Date date) {
        return ByteUtils.timeToStr((Date)date);
    }

    public static String append(byte[] bytes) {
        return ByteUtils.toHexString((byte[])bytes);
    }
}

