/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.utils;

import com.jhscale.meter.utils.ByteUtils;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class NidManagerUtils {
    private Map<String, Integer> manager = new ConcurrentHashMap<String, Integer>();

    private NidManagerUtils() {
    }

    public static NidManagerUtils getInstance() {
        return Singleton.manager;
    }

    public String getNId(String mac) {
        Integer vaule = this.manager.get(mac);
        if (Objects.isNull(vaule)) {
            vaule = 0;
        }
        vaule = vaule + (int)(Math.random() * 256.0);
        String hexData = ByteUtils.int2HexWithPush(vaule, 4);
        this.manager.put(mac, vaule);
        return hexData;
    }

    private static class Singleton {
        private static final NidManagerUtils manager = new NidManagerUtils();

        private Singleton() {
        }
    }
}

