/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.utils;

import com.alibaba.fastjson.JSONObject;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.protocol.print.entity.PrintLOGParam;
import com.jhscale.meter.protocol.print.entity.para.Para;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class PrintUtils {
    private static PrintLOGParam PRINT_LOG_PARAM = new PrintLOGParam();

    private PrintUtils() {
    }

    public static boolean PRINT_LOG_PARAM(PrintLOGParam printLogParam) {
        PRINT_LOG_PARAM = printLogParam;
        return true;
    }

    public static String compile(List<Para> paras) {
        StringBuffer buffer = new StringBuffer();
        if (paras != null && !paras.isEmpty()) {
            for (Para para : paras) {
                buffer.append(para.compile(GlobalPara.getInstance().getWord_encoding()));
            }
        }
        return buffer.toString();
    }

    public static String compile(Para ... paras) {
        return paras != null && paras.length > 0 ? PrintUtils.compile(Arrays.asList(paras)) : "";
    }

    public static void debug(PrintLOGParam param, Object obj) {
        param = Objects.isNull((Object)param) ? PRINT_LOG_PARAM : param;
        long time = System.currentTimeMillis();
        int count = 1;
        try {
            if (param.is_switch() && Objects.nonNull(param.get_length())) {
                String log = JSONObject.toJSONString((Object)obj);
                while (StringUtils.isNotBlank((CharSequence)log)) {
                    if (log.length() <= param.get_length()) {
                        System.out.println(String.format("DEBUG --{ %s }[%s]--- %s ", time, count, log));
                        log = null;
                    } else {
                        System.out.println(String.format("DEBUG --{ %s }[%s]--- %s ", time, count, log.substring(0, param.get_length())));
                        log = log.substring(param.get_length());
                    }
                    ++count;
                }
            }
        }
        catch (Exception e) {
            System.err.printf("DEBUG Log ERROR---{ %s }[%s]---- %s%n", time, count, e.getMessage());
            e.printStackTrace();
        }
    }
}

