/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.meter.utils;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.TooManyListenersException;

public class SerialTool {
    private static SerialTool serialTool = null;

    public static SerialTool getSerialTool() {
        if (serialTool == null) {
            serialTool = new SerialTool();
        }
        return serialTool;
    }

    public static final List<String> findPort() {
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        ArrayList<String> portNameList = new ArrayList<String>();
        while (portList.hasMoreElements()) {
            String portName = ((CommPortIdentifier)portList.nextElement()).getName();
            portNameList.add(portName);
        }
        return portNameList;
    }

    public static final SerialPort openPort(String portName, int baudrate) throws MeterException {
        try {
            CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier((String)portName);
            CommPort commPort = portIdentifier.open(portName, 2000);
            if (commPort instanceof SerialPort) {
                SerialPort serialPort = (SerialPort)commPort;
                serialPort.setSerialPortParams(baudrate, 8, 1, 0);
                return serialPort;
            }
            throw new MeterException(MeterStateEnum.\u7aef\u53e3\u6307\u5411\u8bbe\u5907\u4e0d\u662f\u4e32\u53e3\u7c7b\u578b);
        }
        catch (NoSuchPortException e) {
            e.printStackTrace();
            throw new MeterException(MeterStateEnum.\u6ca1\u6709\u8be5\u7aef\u53e3\u5bf9\u5e94\u7684\u4e32\u53e3\u8bbe\u5907);
        }
        catch (PortInUseException e) {
            e.printStackTrace();
            throw new MeterException(MeterStateEnum.\u7aef\u53e3\u5df2\u88ab\u5360\u7528);
        }
        catch (UnsupportedCommOperationException e) {
            throw new MeterException(MeterStateEnum.\u8bbe\u7f6e\u4e32\u53e3\u53c2\u6570\u5931\u8d25);
        }
    }

    public static void closePort(SerialPort serialPort) {
        if (serialPort != null) {
            serialPort.close();
            serialPort = null;
        }
    }

    public static void sendToPort(SerialPort serialPort, byte[] order) throws MeterException {
        OutputStream out = null;
        try {
            out = serialPort.getOutputStream();
            out.write(order);
            out.flush();
        }
        catch (IOException e) {
            throw new MeterException(MeterStateEnum.\u5411\u4e32\u53e3\u53d1\u9001\u6570\u636e\u5931\u8d25);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                    out = null;
                }
            }
            catch (IOException e) {
                throw new MeterException(MeterStateEnum.\u5173\u95ed\u4e32\u53e3\u5bf9\u8c61\u7684\u8f93\u51fa\u6d41\u51fa\u9519);
            }
        }
    }

    public static byte[] readFromPort(SerialPort serialPort) throws MeterException {
        InputStream in = null;
        byte[] bytes = null;
        try {
            in = serialPort.getInputStream();
            int bufflenth = in.available();
            while (bufflenth != 0) {
                bytes = new byte[bufflenth];
                in.read(bytes);
                bufflenth = in.available();
            }
        }
        catch (IOException e) {
            throw new MeterException(MeterStateEnum.\u4ece\u4e32\u53e3\u8bfb\u53d6\u6570\u636e\u65f6\u51fa\u9519);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                    in = null;
                }
            }
            catch (IOException e) {
                throw new MeterException(MeterStateEnum.\u5173\u95ed\u4e32\u53e3\u5bf9\u8c61\u8f93\u5165\u6d41\u51fa\u9519);
            }
        }
        return bytes;
    }

    public static void addListener(SerialPort port, SerialPortEventListener listener) throws MeterException {
        try {
            port.addEventListener(listener);
            port.notifyOnDataAvailable(true);
            port.notifyOnBreakInterrupt(true);
        }
        catch (TooManyListenersException e) {
            e.printStackTrace();
            throw new MeterException(MeterStateEnum.\u76d1\u542c\u7c7b\u5bf9\u8c61\u8fc7\u591a);
        }
    }

    static {
        if (serialTool == null) {
            serialTool = new SerialTool();
        }
    }
}

